/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.daisy.pipeline.client.Pipeline2Logger;

public class Files {
    public static void addDirectoryToZip(File zipFile, File directory) throws IOException {
        Map<String, File> files = Files.listFilesRecursively(directory, directory.getParentFile().toURI(), true);
        Files.addFilesToZip(zipFile, files);
    }

    public static void addDirectoryContentsToZip(File zipFile, File directory) throws IOException {
        Map<String, File> files = Files.listFilesRecursively(directory, directory.toURI(), true);
        Files.addFilesToZip(zipFile, files);
    }

    public static Map<String, File> listFilesRecursively(File directory, boolean includeDirectories) throws IOException {
        return Files.listFilesRecursively(directory, directory.toURI(), includeDirectories);
    }

    public static Map<String, File> listFilesRecursively(File directory, URI base, boolean includeDirectories) throws IOException {
        HashMap<String, File> files = new HashMap<String, File>();
        if (directory.isDirectory()) {
            if (includeDirectories) {
                String name = base.relativize(directory.toURI()).getPath();
                if (!name.endsWith("/")) {
                    name = name + "/";
                }
                files.put(name, directory);
            }
            for (File file : directory.listFiles()) {
                Map<String, File> subfiles = Files.listFilesRecursively(file, base, includeDirectories);
                files.putAll(subfiles);
            }
        } else if (directory.isFile()) {
            files.put(base.relativize(directory.toURI()).getPath(), directory);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listZipFiles(File zipfile) {
        ArrayList<String> files = new ArrayList<String>();
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> zipEntries = zip.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry entry = zipEntries.nextElement();
                if (entry.isDirectory()) continue;
                files.add(entry.getName());
            }
        }
        catch (IOException e) {
            Pipeline2Logger.logger().error("Unable to list zip files", e);
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException e) {
                Pipeline2Logger.logger().error("Unable to close zip stream", e);
            }
        }
        return files;
    }

    public static void addFilesToZip(File zipFile, File[] files, File baseDirectory) throws IOException {
        URI base = baseDirectory.toURI();
        HashMap<String, File> relativeFiles = new HashMap<String, File>();
        for (File file : files) {
            if (!file.isFile()) continue;
            String name = base.relativize(file.toURI()).getPath();
            relativeFiles.put(name, file);
        }
        Files.addFilesToZip(zipFile, relativeFiles);
    }

    public static void addFilesToZip(File zipFile, Map<String, File> files) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        if (!zipFile.renameTo(tempFile)) {
            throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[0x400000];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String entryName = entry.getName();
            boolean notInFiles = true;
            for (String fileName : files.keySet()) {
                if (!fileName.equals(entryName)) continue;
                notInFiles = false;
                break;
            }
            if (notInFiles) {
                int len;
                Pipeline2Logger.logger().debug("keeping in ZIP: " + entryName);
                out.putNextEntry(new ZipEntry(entryName));
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            entry = zin.getNextEntry();
        }
        zin.close();
        for (String fileName : files.keySet()) {
            int len;
            Pipeline2Logger.logger().debug("adding to ZIP: " + fileName);
            if (files.get(fileName).isDirectory()) continue;
            FileInputStream in = new FileInputStream(files.get(fileName));
            out.putNextEntry(new ZipEntry(fileName));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            ((InputStream)in).close();
        }
        out.close();
        tempFile.delete();
    }

    public static void unzip(File zip, File dir) throws IOException {
        if (!zip.exists()) {
            IOException e = new IOException("ZIP file does not exist: " + (zip != null ? zip.getAbsolutePath() : "[null]"));
            Pipeline2Logger.logger().error("ZIP file does not exist: " + (zip != null ? zip.getAbsolutePath() : "[null]"), e);
            throw e;
        }
        if (!zip.isFile()) {
            IOException e = new IOException("ZIP file is not a file: " + (zip != null ? zip.getAbsolutePath() : "[null]"));
            Pipeline2Logger.logger().error("ZIP file is not a file: " + (zip != null ? zip.getAbsolutePath() : "[null]"), e);
            throw e;
        }
        if (dir.exists() && !dir.isDirectory()) {
            IOException e = new IOException("ZIP output is not a directory: " + (dir != null ? dir.getAbsolutePath() : "[null]"));
            Pipeline2Logger.logger().error("ZIP output is not a directory: " + (dir != null ? dir.getAbsolutePath() : "[null]"), e);
            throw e;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try (ZipInputStream zipIn = new ZipInputStream((InputStream)new FileInputStream(zip), StandardCharsets.UTF_8);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                File file = new File(dir, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
                        int location;
                        byte[] buffer = new byte[4096];
                        while ((location = zipIn.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, location);
                        }
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    public static void zip(File dir, File zip) throws IOException {
        zip.getParentFile().mkdirs();
        ZipOutputStream zipOs = new ZipOutputStream(new FileOutputStream(zip));
        byte[] buff = new byte[0x400000];
        Map<String, File> files = Files.listFilesRecursively(dir, dir.toURI(), true);
        for (String entryName : files.keySet()) {
            ZipEntry entry = new ZipEntry(entryName);
            if (entry.isDirectory()) continue;
            zipOs.putNextEntry(entry);
            FileInputStream is = new FileInputStream(files.get(entryName));
            int read = 0;
            while ((read = ((InputStream)is).read(buff)) > 0) {
                zipOs.write(buff, 0, read);
            }
            ((InputStream)is).close();
        }
        zipOs.close();
    }

    public static void copy(File from, File to) throws IOException {
        if (from.isDirectory()) {
            to.mkdirs();
            for (File fileOrDir : from.listFiles()) {
                Files.copy(fileOrDir, new File(to, fileOrDir.getName()));
            }
        } else if (from.isFile()) {
            java.nio.file.Files.copy(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
        }
    }

    public static String encodeURI(String path) {
        try {
            String url = "";
            String[] dirSplit = path.split("/");
            for (int d = 0; d < dirSplit.length; ++d) {
                if (d > 0) {
                    url = url + "/";
                }
                String[] spaceSplit = dirSplit[d].split(" ");
                for (int s = 0; s < spaceSplit.length; ++s) {
                    if (s > 0) {
                        url = url + "%20";
                    }
                    url = url + URLEncoder.encode(spaceSplit[s], "UTF-8");
                }
            }
            return url;
        }
        catch (UnsupportedEncodingException e) {
            Pipeline2Logger.logger().warn("Could not create URI from '" + path + "'", e);
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            Pipeline2Logger.logger().error("File not found", e);
        }
        catch (IOException e) {
            Pipeline2Logger.logger().error("An error occured while reading the file", e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                Pipeline2Logger.logger().error("Could not close FileReader", e);
            }
        }
        return null;
    }
}

