/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models.datatypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.daisy.pipeline.client.Pipeline2Exception;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.models.DataType;
import org.daisy.pipeline.client.utils.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EnumType
extends DataType {
    public List<Value> values = new ArrayList<Value>();

    public EnumType(Node dataTypeXml) {
        super(dataTypeXml);
        try {
            if (dataTypeXml instanceof Document) {
                dataTypeXml = XPath.selectNode("/*", dataTypeXml, XPath.dp2ns);
            }
            List<Node> valueNodes = XPath.selectNodes("*[local-name()='value']", dataTypeXml, XPath.dp2ns);
            for (int i = 0; i < valueNodes.size(); ++i) {
                Value value = new Value();
                Node valueNode = valueNodes.get(i);
                value.name = XPath.selectText("text()", valueNode, XPath.dp2ns);
                if (value.name == null) {
                    value.name = "";
                }
                List<Node> precedingDocNodes = XPath.selectNodes("/*/*[local-name()='documentation' and not(preceding-sibling::*[local-name()='value'])]/*[local-name()='value' and count(preceding-sibling::*[local-name()='value'])=" + i + "]", dataTypeXml, XPath.dp2ns);
                List<Node> followingDocNodes = XPath.selectNodes("/*/*[local-name()='documentation' and count(preceding-sibling::*[local-name()='value'])=" + (i + 1) + "]", dataTypeXml, XPath.dp2ns);
                ArrayList<Node> docNodes = new ArrayList<Node>();
                docNodes.addAll(precedingDocNodes);
                docNodes.addAll(followingDocNodes);
                for (Node documentation : docNodes) {
                    Node languageNode = XPath.selectNode("ancestor-or-self::*[@xml:lang | @lang | @*[local-name()='lang']]", documentation, XPath.dp2ns);
                    String language = XPath.selectText("(@xml:lang | @lang | @*[local-name()='lang'])[1]", languageNode, XPath.dp2ns);
                    String text = XPath.selectText("text()", documentation, XPath.dp2ns);
                    String[] textSplit = text.split("\n+", 2);
                    String nicename = textSplit[0];
                    String description = textSplit.length == 2 ? textSplit[1] : "";
                    value.nicenames.put(language, nicename);
                    value.descriptions.put(language, description);
                }
                this.values.add(value);
            }
        }
        catch (Pipeline2Exception e) {
            Pipeline2Logger.logger().error("Unable to parse datatype (enum) XML", e);
        }
    }

    public class Value {
        public String name;
        public Map<String, String> nicenames = new HashMap<String, String>();
        public Map<String, String> descriptions = new HashMap<String, String>();

        public String getNicename() {
            Iterator<String> iterator;
            if (this.nicenames.containsKey("")) {
                return this.nicenames.get("");
            }
            if (this.nicenames.containsKey("en")) {
                return this.nicenames.get("en");
            }
            if (!this.nicenames.isEmpty() && (iterator = this.nicenames.keySet().iterator()).hasNext()) {
                String lang = iterator.next();
                return this.nicenames.get(lang);
            }
            return this.name;
        }

        public String getDescription() {
            Iterator<String> iterator;
            if (this.descriptions.containsKey("")) {
                return this.descriptions.get("");
            }
            if (this.descriptions.containsKey("en")) {
                return this.descriptions.get("en");
            }
            if (!this.descriptions.isEmpty() && (iterator = this.descriptions.keySet().iterator()).hasNext()) {
                String lang = iterator.next();
                return this.descriptions.get(lang);
            }
            return "";
        }
    }
}

