/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.filestorage;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.daisy.pipeline.client.Pipeline2Exception;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.models.Argument;
import org.daisy.pipeline.client.models.Job;
import org.daisy.pipeline.client.utils.XML;
import org.w3c.dom.Document;

public class JobStorage {
    private String id;
    private Job job;
    private File directory;
    private Map<String, File> contextFiles = new HashMap<String, File>();
    private boolean lazyLoaded = false;
    private static final Object lock = new Object();

    public JobStorage(Job job, File jobStorage, String id) {
        job.setJobStorage(this);
        this.job = job;
        this.id = id == null ? job.getId() : id;
        this.directory = new File(jobStorage, this.id);
    }

    public JobStorage(Job job, File jobStorage, JobStorage otherJobContext, String id) {
        this(job, jobStorage, id);
        if (otherJobContext != null) {
            for (File f : otherJobContext.getContextDir().listFiles()) {
                this.addContextFile(f, null);
            }
        }
        this.save(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyLoad() {
        if (this.lazyLoaded) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (this.directory != null && this.directory.exists()) {
                File jobFile = new File(this.directory, "job.xml");
                String jobString = null;
                Document jobDocument = null;
                if (jobFile.exists()) {
                    try {
                        byte[] encoded = Files.readAllBytes(Paths.get(jobFile.getPath(), new String[0]));
                        jobString = new String(encoded, Charset.defaultCharset());
                        jobDocument = XML.getXml(jobString);
                    }
                    catch (IOException e) {
                        Pipeline2Logger.logger().error("Unable to load job.xml: " + jobFile.getAbsolutePath(), e);
                    }
                    if (jobDocument != null) {
                        try {
                            if (this.job == null) {
                                this.job = new Job(jobDocument);
                            } else {
                                this.job.setJobXml(jobDocument);
                            }
                        }
                        catch (Pipeline2Exception e) {
                            Pipeline2Logger.logger().error("Failed to load job: " + jobFile.getAbsolutePath(), e);
                        }
                    }
                }
            }
        }
        this.lazyLoaded = true;
    }

    public synchronized void save() {
        this.save(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(boolean moveFiles) {
        this.lazyLoad();
        if (this.directory == null) {
            return;
        }
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        Iterator<Argument> iterator = lock;
        synchronized (iterator) {
            File jobFile = new File(this.directory, "job.xml");
            Document jobDocument = this.job.toXml();
            try {
                String jobRequestString = XML.toString(jobDocument);
                Files.write(jobFile.toPath(), jobRequestString.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                Pipeline2Logger.logger().error("Unable to store XML for job", e);
            }
        }
        for (Argument arg : this.job.getInputs()) {
            List<String> values;
            if (!"anyFileURI".equals(arg.getType()) && !"anyURI".equals(arg.getType()) || (values = arg.getAsList()) == null) continue;
            for (String value : values) {
                this.getContextFile(value);
            }
        }
        if (!this.contextFiles.isEmpty()) {
            File contextDir = new File(this.directory, "context");
            for (String contextPath : this.contextFiles.keySet()) {
                File file = this.contextFiles.get(contextPath);
                if (!file.exists()) {
                    Pipeline2Logger.logger().error("File or directory does not exist and can not be added to context: '" + file.getAbsolutePath() + "'");
                    continue;
                }
                File contextFile = new File(contextDir, contextPath);
                this.contextFiles.put(contextPath, contextFile);
                try {
                    assert (contextFile.getCanonicalPath().startsWith(contextDir.getCanonicalPath() + File.separator));
                    if (file.getCanonicalPath().equals(contextFile.getCanonicalPath())) continue;
                    contextFile.toPath().getParent().toFile().mkdirs();
                    if (moveFiles) {
                        Files.move(file.toPath(), contextFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    Files.copy(file.toPath(), contextFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (IOException e) {
                    Pipeline2Logger.logger().error("Unable to copy from '" + file.getAbsolutePath() + "' to '" + contextFile.getAbsolutePath(), e);
                }
            }
        }
    }

    public static synchronized List<String> listJobs(File jobStorage) {
        ArrayList<String> jobs = new ArrayList<String>();
        if (jobStorage.isDirectory()) {
            for (File directory : jobStorage.listFiles()) {
                if (!directory.isDirectory()) continue;
                String jobId = directory.getName();
                jobs.add(jobId);
            }
        }
        Collections.sort(jobs);
        return jobs;
    }

    public static synchronized Job loadJob(String storageId, File jobStorageDir) {
        File directory = new File(jobStorageDir, storageId);
        if (directory.isDirectory()) {
            Job job = new Job();
            new JobStorage(job, jobStorageDir, storageId);
            return job;
        }
        return null;
    }

    public synchronized void addContextFile(File file, String contextPath) {
        if (contextPath == null) {
            contextPath = file.getName();
        }
        if (file.isFile()) {
            this.contextFiles.put(contextPath, file);
        } else if (file.isDirectory()) {
            if (!contextPath.endsWith("/")) {
                contextPath = contextPath + "/";
            }
            for (File f : file.listFiles()) {
                this.addContextFile(f, contextPath + f.getName());
            }
        }
    }

    public synchronized void removeContextFile(String contextPath) {
        this.contextFiles.remove(contextPath);
    }

    public synchronized String getContextFilePath(File file) {
        for (String contextPath : this.contextFiles.keySet()) {
            if (!this.contextFiles.get(contextPath).equals(file)) continue;
            return contextPath;
        }
        return null;
    }

    public synchronized File getContextFile(String contextPath) {
        File contextFile;
        if (!this.contextFiles.containsKey(contextPath) && (contextFile = new File(this.getContextDir(), contextPath)).isFile()) {
            this.contextFiles.put(contextPath, contextFile);
            return contextFile;
        }
        return this.contextFiles.get(contextPath);
    }

    public synchronized File getContextDir() {
        return new File(this.directory, "context");
    }

    public synchronized File makeContextZip() {
        try {
            File zip = Files.createTempFile("dp2client", ".zip", new FileAttribute[0]).toFile();
            org.daisy.pipeline.client.utils.Files.zip(this.getContextDir(), zip);
            return zip;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized boolean existsInContext(String contextPath) {
        return this.contextFiles.containsKey(contextPath);
    }

    public synchronized boolean isFileInContext(String contextPath) {
        File file = this.getContextFile(contextPath);
        return file != null && file.isFile();
    }

    public synchronized boolean isDirectoryInContext(String contextPath) {
        if (contextPath == null) {
            return false;
        }
        String dirPath = contextPath + (contextPath.endsWith("/") ? "" : "/");
        for (String path : this.contextFiles.keySet()) {
            if (!path.startsWith(dirPath)) continue;
            return true;
        }
        return false;
    }

    public synchronized void delete() {
        if (this.directory != null && this.directory.exists()) {
            try {
                this.deleteRecursively(this.directory);
            }
            catch (IOException e) {
                Pipeline2Logger.logger().error("Unable to delete job: " + this.directory.getAbsolutePath(), e);
            }
        }
    }

    private synchronized void deleteRecursively(File directory) throws IOException {
        if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                this.deleteRecursively(file);
            }
        }
        Files.delete(directory.toPath());
    }

    public synchronized String getStorageId() {
        return this.id;
    }
}

