/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.drive.adaptee;

import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.ctoolkit.restapi.client.Identifier;
import org.ctoolkit.restapi.client.adaptee.DeleteExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.InsertExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.MediaProvider;
import org.ctoolkit.restapi.client.adaptee.PatchAdaptee;
import org.ctoolkit.restapi.client.adapter.AbstractGoogleClientAdaptee;

public class FileAdaptee
extends AbstractGoogleClientAdaptee<Drive, File>
implements InsertExecutorAdaptee<File>,
DeleteExecutorAdaptee<File>,
PatchAdaptee<Drive.Files> {
    @Inject
    public FileAdaptee(Drive client) {
        super((Object)client);
    }

    public Drive.Files.Create prepareInsert(@Nonnull File resource, @Nullable Identifier parentKey, @Nullable MediaProvider<?> provider) throws IOException {
        Preconditions.checkNotNull((Object)resource);
        Drive.Files.Create insert = provider == null ? ((Drive)this.client()).files().create(resource) : ((Drive)this.client()).files().create(resource, this.media(provider));
        return insert;
    }

    public File executeInsert(@Nonnull Object request, @Nullable Map<String, Object> parameters, @Nullable Locale locale) throws IOException {
        Preconditions.checkNotNull((Object)request);
        this.fill(this.get(request), parameters, locale);
        return (File)this.execute(request);
    }

    public Drive.Files.Delete prepareDelete(@Nonnull Identifier identifier) throws IOException {
        Preconditions.checkNotNull((Object)identifier);
        return ((Drive)this.client()).files().delete(identifier.getString());
    }

    public void executeDelete(@Nonnull Object request, @Nullable Map<String, Object> parameters, @Nullable Locale locale) throws IOException {
        Preconditions.checkNotNull((Object)request);
        this.acceptLanguage(this.get(request), locale);
        this.execute(request);
    }

    public Drive.Files preparePatch(Object resource, Identifier identifier) throws IOException {
        return ((Drive)this.client()).files();
    }
}

