/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.linux.aarch64;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.atomic.AtomicReference;
import org.cryptomator.jfuse.linux.aarch64.extr.fuse3.fuse_h;

public class FuseNewHelper {
    private static final AtomicReference<FuseNewHelper> INSTANCE = new AtomicReference<Object>(null);
    private static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.loaderLookup().or(Linker.nativeLinker().defaultLookup());
    private static final FunctionDescriptor DESC = FunctionDescriptor.of(fuse_h.C_POINTER, fuse_h.C_POINTER, fuse_h.C_POINTER, fuse_h.C_LONG, fuse_h.C_POINTER);
    private final MethodHandle fuse_new;

    private FuseNewHelper(String symbolName) {
        this.fuse_new = Linker.nativeLinker().downcallHandle(FuseNewHelper.findOrThrow(symbolName), DESC, new Linker.Option[0]);
    }

    public MemorySegment fuse_new(MemorySegment args, MemorySegment op, long op_size, MemorySegment private_data) {
        try {
            return this.fuse_new.invokeExact(args, op, op_size, private_data);
        }
        catch (Throwable ex) {
            throw new AssertionError("should not reach here", ex);
        }
    }

    public static synchronized FuseNewHelper getInstance() {
        if (INSTANCE.get() == null) {
            INSTANCE.set(FuseNewHelper.createInstance());
        }
        return INSTANCE.get();
    }

    private static FuseNewHelper createInstance() throws IllegalStateException {
        if (FuseNewHelper.getLibVersion() < 317) {
            return new FuseNewHelper("fuse_new");
        }
        return new FuseNewHelper("fuse_new_31");
    }

    private static int getLibVersion() {
        MemorySegment fuse_versionSymbol = SymbolLookup.loaderLookup().find("fuse_version").orElseThrow();
        MethodHandle fuse_versionMethodHandle = Linker.nativeLinker().downcallHandle(fuse_versionSymbol, FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]), new Linker.Option[0]);
        try {
            return fuse_versionMethodHandle.invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to call native method fuse_version", e);
        }
    }

    private static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }
}

