/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.testing;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.conscrypt.testing.TestUtil;

public final class NettyServer {
    private final int port;
    private final int messageSize;
    private EventLoopGroup group;
    private Channel channel;
    private String cipher;
    private volatile MessageProcessor messageProcessor = new BatchMessageProcessor(1);

    public NettyServer(int port, int messageSize, String cipher) {
        this.port = port;
        this.messageSize = messageSize;
        this.cipher = cipher;
    }

    public void setMessageProcessor(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public void start() {
        this.group = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        b.group(this.group);
        b.channel(NioServerSocketChannel.class);
        b.option(ChannelOption.SO_BACKLOG, (Object)128);
        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel ch) throws Exception {
                SslContext context = TestUtil.newNettyServerContext(NettyServer.this.cipher);
                SSLEngine sslEngine = context.newEngine(ch.alloc());
                ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(sslEngine)});
                ch.pipeline().addLast(new ChannelHandler[]{new MessageDecoder()});
            }
        });
        ChannelFuture future = b.bind(this.port);
        try {
            future.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted waiting for bind");
        }
        if (!future.isSuccess()) {
            throw new RuntimeException("Failed to bind", future.cause());
        }
        this.channel = future.channel();
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.close().awaitUninterruptibly();
        }
        if (this.group != null) {
            try {
                this.group.shutdownGracefully(1L, 5L, TimeUnit.SECONDS).get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class MessageDecoder
    extends ByteToMessageDecoder {
        private MessageDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() >= NettyServer.this.messageSize) {
                NettyServer.this.messageProcessor.processMessage(ctx, in.readSlice(NettyServer.this.messageSize));
            }
        }
    }

    static final class BatchMessageProcessor
    implements MessageProcessor {
        private final int batchSize;
        private int messageCount;

        BatchMessageProcessor(int batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public void processMessage(ChannelHandlerContext ctx, ByteBuf request) {
            if (this.messageCount == this.batchSize - 1) {
                ctx.writeAndFlush((Object)request);
            }
            this.messageCount = (this.messageCount + 1) % this.batchSize;
        }
    }

    public static interface MessageProcessor {
        public void processMessage(ChannelHandlerContext var1, ByteBuf var2);
    }
}

