/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import javax.crypto.SecretKey;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.conscrypt.AbstractOpenSSLSession;
import org.conscrypt.AbstractSessionContext;
import org.conscrypt.ArrayUtils;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLECGroupContext;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLSessionImpl;
import org.conscrypt.OpenSSLX509Certificate;
import org.conscrypt.PSKKeyManager;
import org.conscrypt.Platform;
import org.conscrypt.SSLNullSession;
import org.conscrypt.SSLParametersImpl;

public class OpenSSLSocketImpl
extends SSLSocket
implements NativeCrypto.SSLHandshakeCallbacks,
SSLParametersImpl.AliasChooser,
SSLParametersImpl.PSKCallbacks {
    private static final boolean DBG_STATE = false;
    private final Object stateLock = new Object();
    private static final int STATE_NEW = 0;
    private static final int STATE_HANDSHAKE_STARTED = 1;
    private static final int STATE_HANDSHAKE_COMPLETED = 2;
    private static final int STATE_READY_HANDSHAKE_CUT_THROUGH = 3;
    private static final int STATE_READY = 4;
    private static final int STATE_CLOSED = 5;
    private int state = 0;
    private long sslNativePointer;
    private SSLInputStream is;
    private SSLOutputStream os;
    private final Socket socket;
    private final boolean autoClose;
    private String peerHostname;
    private final int peerPort;
    private final SSLParametersImpl sslParameters;
    private final Object guard = Platform.closeGuardGet();
    private ArrayList<HandshakeCompletedListener> listeners;
    private OpenSSLKey channelIdPrivateKey;
    private AbstractOpenSSLSession sslSession;
    private AbstractOpenSSLSession handshakeSession;
    private int readTimeoutMilliseconds = 0;
    private int writeTimeoutMilliseconds = 0;
    private int handshakeTimeoutMilliseconds = -1;

    OpenSSLSocketImpl(SSLParametersImpl sslParameters) throws IOException {
        this.socket = this;
        this.peerHostname = null;
        this.peerPort = -1;
        this.autoClose = false;
        this.sslParameters = sslParameters;
    }

    OpenSSLSocketImpl(String hostname, int port, SSLParametersImpl sslParameters) throws IOException {
        super(hostname, port);
        this.socket = this;
        this.peerHostname = hostname;
        this.peerPort = port;
        this.autoClose = false;
        this.sslParameters = sslParameters;
    }

    OpenSSLSocketImpl(InetAddress address, int port, SSLParametersImpl sslParameters) throws IOException {
        super(address, port);
        this.socket = this;
        this.peerHostname = null;
        this.peerPort = -1;
        this.autoClose = false;
        this.sslParameters = sslParameters;
    }

    OpenSSLSocketImpl(String hostname, int port, InetAddress clientAddress, int clientPort, SSLParametersImpl sslParameters) throws IOException {
        super(hostname, port, clientAddress, clientPort);
        this.socket = this;
        this.peerHostname = hostname;
        this.peerPort = port;
        this.autoClose = false;
        this.sslParameters = sslParameters;
    }

    OpenSSLSocketImpl(InetAddress address, int port, InetAddress clientAddress, int clientPort, SSLParametersImpl sslParameters) throws IOException {
        super(address, port, clientAddress, clientPort);
        this.socket = this;
        this.peerHostname = null;
        this.peerPort = -1;
        this.autoClose = false;
        this.sslParameters = sslParameters;
    }

    OpenSSLSocketImpl(Socket socket, String hostname, int port, boolean autoClose, SSLParametersImpl sslParameters) throws IOException {
        this.socket = socket;
        this.peerHostname = hostname;
        this.peerPort = port;
        this.autoClose = autoClose;
        this.sslParameters = sslParameters;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.peerHostname == null && endpoint instanceof InetSocketAddress) {
            this.peerHostname = Platform.getHostStringFromInetSocketAddress((InetSocketAddress)endpoint);
        }
        super.connect(endpoint, timeout);
    }

    private void checkOpen() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startHandshake() throws IOException {
        boolean handshakeCompleted;
        long sslSessionNativePointer;
        int savedWriteTimeoutMilliseconds;
        int savedReadTimeoutMilliseconds;
        AbstractOpenSSLSession sessionToReuse;
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) return;
            this.state = 1;
        }
        boolean client = this.sslParameters.getUseClientMode();
        this.sslNativePointer = 0L;
        boolean releaseResources = true;
        try {
            AbstractSessionContext sessionContext = this.sslParameters.getSessionContext();
            this.sslNativePointer = NativeCrypto.SSL_new(sessionContext.sslCtxNativePointer);
            Platform.closeGuardOpen(this.guard, "close");
            boolean enableSessionCreation = this.getEnableSessionCreation();
            if (!enableSessionCreation) {
                NativeCrypto.SSL_set_session_creation_enabled(this.sslNativePointer, enableSessionCreation);
            }
            NativeCrypto.SSL_accept_renegotiations(this.sslNativePointer);
            if (client) {
                NativeCrypto.SSL_set_connect_state(this.sslNativePointer);
                NativeCrypto.SSL_enable_ocsp_stapling(this.sslNativePointer);
                if (this.sslParameters.isCTVerificationEnabled(this.getHostname())) {
                    NativeCrypto.SSL_enable_signed_cert_timestamps(this.sslNativePointer);
                }
            } else {
                NativeCrypto.SSL_set_accept_state(this.sslNativePointer);
                if (this.sslParameters.getOCSPResponse() != null) {
                    NativeCrypto.SSL_enable_ocsp_stapling(this.sslNativePointer);
                }
            }
            sessionToReuse = this.sslParameters.getSessionToReuse(this.sslNativePointer, this.getHostnameOrIP(), this.getPort());
            this.sslParameters.setSSLParameters(this.sslNativePointer, this, this, this.getHostname());
            this.sslParameters.setCertificateValidation(this.sslNativePointer);
            this.sslParameters.setTlsChannelId(this.sslNativePointer, this.channelIdPrivateKey);
            savedReadTimeoutMilliseconds = this.getSoTimeout();
            savedWriteTimeoutMilliseconds = this.getSoWriteTimeout();
            if (this.handshakeTimeoutMilliseconds >= 0) {
                this.setSoTimeout(this.handshakeTimeoutMilliseconds);
                this.setSoWriteTimeout(this.handshakeTimeoutMilliseconds);
            }
            Object object2 = this.stateLock;
            synchronized (object2) {
                if (this.state == 5) {
                    return;
                }
            }
            try {
                NativeCrypto.SSL_do_handshake(this.sslNativePointer, Platform.getFileDescriptor(this.socket), this, this.getSoTimeout());
                sslSessionNativePointer = NativeCrypto.SSL_get1_session(this.sslNativePointer);
            }
            catch (CertificateException e) {
                SSLHandshakeException wrapper = new SSLHandshakeException(e.getMessage());
                wrapper.initCause(e);
                throw wrapper;
            }
            catch (SSLException e) {
                Object wrapper = this.stateLock;
                synchronized (wrapper) {
                    if (this.state != 5) {
                        // MONITOREXIT @DISABLED, blocks:[1, 36, 53, 28] lbl56 : MonitorExitStatement: MONITOREXIT : wrapper
                        String message = e.getMessage();
                        if (!message.contains("unexpected CCS")) throw e;
                        String logMessage = String.format("ssl_unexpected_ccs: host=%s", this.getHostnameOrIP());
                        Platform.logEvent(logMessage);
                        throw e;
                    }
                }
                if (!releaseResources) return;
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.state = 5;
                    this.stateLock.notifyAll();
                }
                try {
                    this.shutdownAndFreeSslNative();
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            handshakeCompleted = false;
        }
        catch (SSLProtocolException e) {
            throw (SSLHandshakeException)new SSLHandshakeException("Handshake failed").initCause(e);
        }
        Object object4 = this.stateLock;
        synchronized (object4) {
            if (this.state == 2) {
                handshakeCompleted = true;
            } else if (this.state == 5) {
                return;
            }
        }
        this.sslSession = this.sslParameters.setupSession(sslSessionNativePointer, this.sslNativePointer, sessionToReuse, this.getHostnameOrIP(), this.getPort(), handshakeCompleted);
        if (this.handshakeTimeoutMilliseconds >= 0) {
            this.setSoTimeout(savedReadTimeoutMilliseconds);
            this.setSoWriteTimeout(savedWriteTimeoutMilliseconds);
        }
        if (handshakeCompleted) {
            this.notifyHandshakeCompletedListeners();
        }
        object4 = this.stateLock;
        synchronized (object4) {
            boolean bl = releaseResources = this.state == 5;
            if (this.state == 1) {
                this.state = 3;
            } else if (this.state == 2) {
                this.state = 4;
            }
            if (releaseResources) return;
            this.stateLock.notifyAll();
            return;
        }
        finally {
            if (releaseResources) {
                Object object5 = this.stateLock;
                synchronized (object5) {
                    this.state = 5;
                    this.stateLock.notifyAll();
                }
                try {
                    this.shutdownAndFreeSslNative();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getHostname() {
        return this.peerHostname;
    }

    public String getHostnameOrIP() {
        if (this.peerHostname != null) {
            return this.peerHostname;
        }
        InetAddress peerAddress = this.getInetAddress();
        if (peerAddress != null) {
            return peerAddress.getHostAddress();
        }
        return null;
    }

    @Override
    public int getPort() {
        return this.peerPort == -1 ? super.getPort() : this.peerPort;
    }

    @Override
    public void clientCertificateRequested(byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals) throws CertificateEncodingException, SSLException {
        this.sslParameters.chooseClientCertificate(keyTypeBytes, asn1DerEncodedPrincipals, this.sslNativePointer, this);
    }

    @Override
    public int clientPSKKeyRequested(String identityHint, byte[] identity, byte[] key) {
        return this.sslParameters.clientPSKKeyRequested(identityHint, identity, key, this);
    }

    @Override
    public int serverPSKKeyRequested(String identityHint, String identity, byte[] key) {
        return this.sslParameters.serverPSKKeyRequested(identityHint, identity, key, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSSLStateChange(int type, int val) {
        if (type != 32) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                this.state = 2;
                return;
            }
            if (this.state != 3 && this.state == 5) {
                return;
            }
        }
        this.sslSession.resetId();
        AbstractSessionContext sessionContext = this.sslParameters.getUseClientMode() ? this.sslParameters.getClientSessionContext() : this.sslParameters.getServerSessionContext();
        sessionContext.putSession(this.sslSession);
        this.notifyHandshakeCompletedListeners();
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.state = 4;
            this.stateLock.notifyAll();
        }
    }

    void notifyHandshakeCompletedListeners() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.sslSession);
            for (HandshakeCompletedListener listener : this.listeners) {
                try {
                    listener.handshakeCompleted(event);
                }
                catch (RuntimeException e) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                }
            }
        }
    }

    @Override
    public void verifyCertificateChain(long[] certRefs, String authMethod) throws CertificateException {
        try {
            X509TrustManager x509tm = this.sslParameters.getX509TrustManager();
            if (x509tm == null) {
                throw new CertificateException("No X.509 TrustManager");
            }
            if (certRefs == null || certRefs.length == 0) {
                throw new SSLException("Peer sent no certificate");
            }
            X509Certificate[] peerCertChain = OpenSSLX509Certificate.createCertChain(certRefs);
            byte[] ocspData = NativeCrypto.SSL_get_ocsp_response(this.sslNativePointer);
            byte[] tlsSctData = NativeCrypto.SSL_get_signed_cert_timestamp_list(this.sslNativePointer);
            this.handshakeSession = new OpenSSLSessionImpl(NativeCrypto.SSL_get1_session(this.sslNativePointer), null, peerCertChain, ocspData, tlsSctData, this.getHostnameOrIP(), this.getPort(), null);
            boolean client = this.sslParameters.getUseClientMode();
            if (client) {
                Platform.checkServerTrusted(x509tm, peerCertChain, authMethod, this);
            } else {
                String authType = ((OpenSSLX509Certificate)peerCertChain[0]).getPublicKey().getAlgorithm();
                Platform.checkClientTrusted(x509tm, peerCertChain, authType, this);
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
        finally {
            this.handshakeSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        SSLInputStream returnVal;
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 5) {
                throw new SocketException("Socket is closed.");
            }
            if (this.is == null) {
                this.is = new SSLInputStream();
            }
            returnVal = this.is;
        }
        this.waitForHandshake();
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        SSLOutputStream returnVal;
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 5) {
                throw new SocketException("Socket is closed.");
            }
            if (this.os == null) {
                this.os = new SSLOutputStream();
            }
            returnVal = this.os;
        }
        this.waitForHandshake();
        return returnVal;
    }

    private void assertReadableOrWriteableState() {
        if (this.state == 4 || this.state == 3) {
            return;
        }
        throw new AssertionError((Object)("Invalid state: " + this.state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForHandshake() throws IOException {
        this.startHandshake();
        Object object = this.stateLock;
        synchronized (object) {
            while (this.state != 4 && this.state != 3 && this.state != 5) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted waiting for handshake", e);
                }
            }
            if (this.state == 5) {
                throw new SocketException("Socket is closed");
            }
        }
    }

    @Override
    public SSLSession getSession() {
        if (this.sslSession == null) {
            try {
                this.waitForHandshake();
            }
            catch (IOException e) {
                return SSLNullSession.getNullSession();
            }
        }
        return Platform.wrapSSLSession(this.sslSession);
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslParameters.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setEnabledCipherSuites(suites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslParameters.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setEnabledProtocols(protocols);
    }

    public void setUseSessionTickets(boolean useSessionTickets) {
        this.sslParameters.setUseSessionTickets(useSessionTickets);
    }

    public void setHostname(String hostname) {
        this.sslParameters.setUseSni(hostname != null);
        this.peerHostname = hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelIdEnabled(boolean enabled) {
        if (this.getUseClientMode()) {
            throw new IllegalStateException("Client mode");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException("Could not enable/disable Channel ID after the initial handshake has begun.");
            }
        }
        this.sslParameters.channelIdEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getChannelId() throws SSLException {
        if (this.getUseClientMode()) {
            throw new IllegalStateException("Client mode");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 4) {
                throw new IllegalStateException("Channel ID is only available after handshake completes");
            }
        }
        return NativeCrypto.SSL_get_tls_channel_id(this.sslNativePointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelIdPrivateKey(PrivateKey privateKey) {
        if (!this.getUseClientMode()) {
            throw new IllegalStateException("Server mode");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException("Could not change Channel ID private key after the initial handshake has begun.");
            }
        }
        if (privateKey == null) {
            this.sslParameters.channelIdEnabled = false;
            this.channelIdPrivateKey = null;
        } else {
            this.sslParameters.channelIdEnabled = true;
            try {
                ECParameterSpec ecParams = null;
                if (privateKey instanceof ECKey) {
                    ecParams = ((ECKey)((Object)privateKey)).getParams();
                }
                if (ecParams == null) {
                    ecParams = OpenSSLECGroupContext.getCurveByName("prime256v1").getECParameterSpec();
                }
                this.channelIdPrivateKey = OpenSSLKey.fromECPrivateKeyForTLSStackOnly(privateKey, ecParams);
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseClientMode(boolean mode) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalArgumentException("Could not change the mode after the initial handshake has begun.");
            }
        }
        this.sslParameters.setUseClientMode(mode);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Method sendUrgentData() is not supported.");
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        throw new SocketException("Methods sendUrgentData, setOOBInline are not supported.");
    }

    @Override
    public void setSoTimeout(int readTimeoutMilliseconds) throws SocketException {
        if (this.socket != this) {
            this.socket.setSoTimeout(readTimeoutMilliseconds);
        } else {
            super.setSoTimeout(readTimeoutMilliseconds);
        }
        this.readTimeoutMilliseconds = readTimeoutMilliseconds;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.readTimeoutMilliseconds;
    }

    public void setSoWriteTimeout(int writeTimeoutMilliseconds) throws SocketException {
        this.writeTimeoutMilliseconds = writeTimeoutMilliseconds;
        Platform.setSocketWriteTimeout(this, writeTimeoutMilliseconds);
    }

    public int getSoWriteTimeout() throws SocketException {
        return this.writeTimeoutMilliseconds;
    }

    public void setHandshakeTimeout(int handshakeTimeoutMilliseconds) throws SocketException {
        this.handshakeTimeoutMilliseconds = handshakeTimeoutMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        SSLInputStream sslInputStream = null;
        SSLOutputStream sslOutputStream = null;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 5) {
                return;
            }
            int oldState = this.state;
            this.state = 5;
            if (oldState == 0) {
                this.closeUnderlyingSocket();
                this.stateLock.notifyAll();
                return;
            }
            if (oldState != 4 && oldState != 3) {
                NativeCrypto.SSL_interrupt(this.sslNativePointer);
                this.stateLock.notifyAll();
                return;
            }
            this.stateLock.notifyAll();
            sslInputStream = this.is;
            sslOutputStream = this.os;
        }
        if (sslInputStream != null || sslOutputStream != null) {
            NativeCrypto.SSL_interrupt(this.sslNativePointer);
        }
        if (sslInputStream != null) {
            sslInputStream.awaitPendingOps();
        }
        if (sslOutputStream != null) {
            sslOutputStream.awaitPendingOps();
        }
        this.shutdownAndFreeSslNative();
    }

    private void shutdownAndFreeSslNative() throws IOException {
        try {
            Platform.blockGuardOnNetwork();
            NativeCrypto.SSL_shutdown(this.sslNativePointer, Platform.getFileDescriptor(this.socket), this);
        }
        catch (IOException iOException) {
        }
        finally {
            this.free();
            this.closeUnderlyingSocket();
        }
    }

    private void closeUnderlyingSocket() throws IOException {
        if (this.socket != this) {
            if (this.autoClose && !this.socket.isClosed()) {
                this.socket.close();
            }
        } else if (!super.isClosed()) {
            super.close();
        }
    }

    private void free() {
        if (this.sslNativePointer == 0L) {
            return;
        }
        NativeCrypto.SSL_free(this.sslNativePointer);
        this.sslNativePointer = 0L;
        Platform.closeGuardClose(this.guard);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                Platform.closeGuardWarnIfOpen(this.guard);
            }
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    public FileDescriptor getFileDescriptor$() {
        if (this.socket == this) {
            return Platform.getFileDescriptorFromSSLSocket(this);
        }
        return Platform.getFileDescriptor(this.socket);
    }

    public byte[] getNpnSelectedProtocol() {
        return null;
    }

    public byte[] getAlpnSelectedProtocol() {
        return NativeCrypto.SSL_get0_alpn_selected(this.sslNativePointer);
    }

    public void setNpnProtocols(byte[] npnProtocols) {
    }

    public void setAlpnProtocols(String[] alpnProtocols) {
        this.sslParameters.setAlpnProtocols(alpnProtocols);
    }

    public void setAlpnProtocols(byte[] alpnProtocols) {
        this.sslParameters.setAlpnProtocols(alpnProtocols);
    }

    @Override
    public SSLParameters getSSLParameters() {
        SSLParameters params = super.getSSLParameters();
        Platform.getSSLParameters(params, this.sslParameters, this);
        return params;
    }

    @Override
    public void setSSLParameters(SSLParameters p) {
        super.setSSLParameters(p);
        Platform.setSSLParameters(p, this.sslParameters, this);
    }

    @Override
    public String chooseServerAlias(X509KeyManager keyManager, String keyType) {
        return keyManager.chooseServerAlias(keyType, null, this);
    }

    @Override
    public String chooseClientAlias(X509KeyManager keyManager, X500Principal[] issuers, String[] keyTypes) {
        return keyManager.chooseClientAlias(keyTypes, null, this);
    }

    @Override
    public String chooseServerPSKIdentityHint(PSKKeyManager keyManager) {
        return keyManager.chooseServerKeyIdentityHint(this);
    }

    @Override
    public String chooseClientPSKIdentity(PSKKeyManager keyManager, String identityHint) {
        return keyManager.chooseClientKeyIdentity(identityHint, this);
    }

    @Override
    public SecretKey getPSKKey(PSKKeyManager keyManager, String identityHint, String identity) {
        return keyManager.getKey(identityHint, identity, this);
    }

    private class SSLOutputStream
    extends OutputStream {
        private final Object writeLock = new Object();

        SSLOutputStream() {
        }

        @Override
        public void write(int oneByte) throws IOException {
            byte[] buffer = new byte[]{(byte)(oneByte & 0xFF)};
            this.write(buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf, int offset, int byteCount) throws IOException {
            Platform.blockGuardOnNetwork();
            OpenSSLSocketImpl.this.checkOpen();
            ArrayUtils.checkOffsetAndCount(buf.length, offset, byteCount);
            if (byteCount == 0) {
                return;
            }
            Object object = this.writeLock;
            synchronized (object) {
                Object object2 = OpenSSLSocketImpl.this.stateLock;
                synchronized (object2) {
                    if (OpenSSLSocketImpl.this.state == 5) {
                        throw new SocketException("socket is closed");
                    }
                }
                NativeCrypto.SSL_write(OpenSSLSocketImpl.this.sslNativePointer, Platform.getFileDescriptor(OpenSSLSocketImpl.this.socket), OpenSSLSocketImpl.this, buf, offset, byteCount, OpenSSLSocketImpl.this.writeTimeoutMilliseconds);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitPendingOps() {
            Object object = this.writeLock;
            synchronized (object) {
            }
        }
    }

    private class SSLInputStream
    extends InputStream {
        private final Object readLock = new Object();

        SSLInputStream() {
        }

        @Override
        public int read() throws IOException {
            byte[] buffer = new byte[1];
            int result = this.read(buffer, 0, 1);
            return result != -1 ? buffer[0] & 0xFF : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf, int offset, int byteCount) throws IOException {
            Platform.blockGuardOnNetwork();
            OpenSSLSocketImpl.this.checkOpen();
            ArrayUtils.checkOffsetAndCount(buf.length, offset, byteCount);
            if (byteCount == 0) {
                return 0;
            }
            Object object = this.readLock;
            synchronized (object) {
                Object object2 = OpenSSLSocketImpl.this.stateLock;
                synchronized (object2) {
                    if (OpenSSLSocketImpl.this.state == 5) {
                        throw new SocketException("socket is closed");
                    }
                }
                return NativeCrypto.SSL_read(OpenSSLSocketImpl.this.sslNativePointer, Platform.getFileDescriptor(OpenSSLSocketImpl.this.socket), OpenSSLSocketImpl.this, buf, offset, byteCount, OpenSSLSocketImpl.this.getSoTimeout());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitPendingOps() {
            Object object = this.readLock;
            synchronized (object) {
            }
        }
    }
}

