/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta.transaction.processor;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.transaction.support.AbstractJobBasedTransactionProcessor;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJobs;
import org.compass.needle.terracotta.transaction.processor.TerracottaTransactionProcessorFactory;

public class TerracottaTransactionProcessor
extends AbstractJobBasedTransactionProcessor {
    private static final Log logger = LogFactory.getLog(TerracottaTransactionProcessor.class);
    private final TerracottaTransactionProcessorFactory processorFactory;
    private transient Map<String, TransactionJobs> committedJobs;

    public TerracottaTransactionProcessor(LuceneSearchEngine searchEngine, TerracottaTransactionProcessorFactory processorFactory) {
        super(logger, searchEngine, true);
        this.processorFactory = processorFactory;
    }

    public String getName() {
        return "tc";
    }

    protected void doPrepare(TransactionJobs jobs) throws SearchEngineException {
    }

    protected void doFlushCommit(TransactionJobs jobs) {
        this.processorFactory.add(jobs);
    }

    protected void doCommit(boolean onePhase, TransactionJobs jobs) throws SearchEngineException {
        this.committedJobs = this.processorFactory.add(jobs);
    }

    protected void doRollback(TransactionJobs jobs) throws SearchEngineException {
        if (this.committedJobs != null) {
            this.processorFactory.remove(this.committedJobs);
        }
    }
}

