/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.terracotta;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.LuceneFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.compass.needle.terracotta.FlushOnCloseTerracottaIndexOutput;
import org.compass.needle.terracotta.TerracottaFile;
import org.compass.needle.terracotta.TerracottaIndexInput;
import org.compass.needle.terracotta.TerracottaIndexOutput;
import org.compass.needle.terracotta.TerracottaLockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaDirectory
extends Directory {
    public static final transient TerracottaFile EMPTY_FILE = new TerracottaFile();
    public static final transient int DEFAULT_BUFFER_SIZE = 4096;
    public static final transient int DEFAULT_FLUSH_RATE = 10;
    public static final transient int DEFAULT_CHM_CONCURRENCY_LEVEL = 160;
    public static final transient float DEFAULT_CHM_LOAD_FACTOR = 0.75f;
    public static final transient int DEFAULT_CHM_INITIAL_CAPACITY = 160;
    private static final transient Log log = LogFactory.getLog(TerracottaDirectory.class);
    private final Map<String, TerracottaFile> fileMap;
    private final int bufferSize;
    private final int flushRate;

    public TerracottaDirectory() {
        this(4096, 10);
    }

    public TerracottaDirectory(int bufferSize, int flushRate) {
        this(bufferSize, flushRate, 160, 0.75f, 160);
    }

    public TerracottaDirectory(int bufferSize, int flushRate, int chmInitialCapacity, float chmLoadFactor, int chmConcurrencyLevel) {
        this.bufferSize = bufferSize;
        this.flushRate = flushRate;
        this.fileMap = this.createMap(chmInitialCapacity, chmLoadFactor, chmConcurrencyLevel);
        this.setLockFactory(new TerracottaLockFactory());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using Terracota lock factory [" + this.getLockFactory() + "]"));
        }
    }

    public TerracottaDirectory(Directory dir) throws IOException {
        this(dir, false);
    }

    private TerracottaDirectory(Directory dir, boolean closeDir) throws IOException {
        this(4096, 10);
        Directory.copy((Directory)dir, (Directory)this, (boolean)closeDir);
    }

    public TerracottaDirectory(File dir) throws IOException {
        this((Directory)FSDirectory.getDirectory((File)dir), true);
    }

    public TerracottaDirectory(String dir) throws IOException {
        this((Directory)FSDirectory.getDirectory((String)dir), true);
    }

    protected Map<String, TerracottaFile> createMap(int chmInitialCapacity, float chmLoadFactor, int chmConcurrencyLevel) {
        return new ConcurrentHashMap<String, TerracottaFile>(chmInitialCapacity, chmLoadFactor, chmConcurrencyLevel);
    }

    public synchronized void setLockFactory(LockFactory lockFactory) {
        super.setLockFactory(lockFactory);
    }

    public synchronized LockFactory getLockFactory() {
        return super.getLockFactory();
    }

    public String[] list() {
        Set<String> fileNames = this.fileMap.keySet();
        return fileNames.toArray(new String[0]);
    }

    public boolean fileExists(String name) {
        return this.fileMap.containsKey(name);
    }

    public long fileModified(String name) throws IOException {
        TerracottaFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLastModified();
    }

    public void touchFile(String name) throws IOException {
        long ts2;
        TerracottaFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        file.setLastModified(ts2);
    }

    public long fileLength(String name) throws IOException {
        TerracottaFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    public void deleteFile(String name) throws IOException {
        TerracottaFile file = this.fileMap.remove(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
    }

    public void renameFile(String from, String to) throws IOException {
        TerracottaFile fromFile = this.fileMap.get(from);
        if (fromFile == null) {
            throw new FileNotFoundException(from);
        }
        this.fileMap.remove(from);
        this.fileMap.put(to, fromFile);
    }

    public IndexOutput createOutput(String name) throws IOException {
        IndexOutput indexOutput = LuceneFileNames.isSegmentsFile(name) ? new FlushOnCloseTerracottaIndexOutput(this, name) : new TerracottaIndexOutput(this, name);
        return indexOutput;
    }

    public IndexInput openInput(String name) throws IOException {
        TerracottaFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return new TerracottaIndexInput(file, this.bufferSize);
    }

    void addFile(String name, TerracottaFile file) throws IOException {
        this.fileMap.put(name, file);
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    int getFlushRate() {
        return this.flushRate;
    }

    public void close() {
    }
}

