/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.support.parallel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.util.concurrent.NamedThreadFactory;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.support.parallel.IndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.compass.gps.device.support.parallel.ParallelIndexExecutor;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public class ConcurrentParallelIndexExecutor
implements ParallelIndexExecutor {
    private static final Log log = LogFactory.getLog(ConcurrentParallelIndexExecutor.class);
    private int maxThreads = -1;

    public ConcurrentParallelIndexExecutor() {
    }

    public ConcurrentParallelIndexExecutor(int maxThreads) {
        if (maxThreads < -1 || maxThreads == 0) {
            throw new IllegalArgumentException("maxThreads must either be -1 or a value greater than 0");
        }
        this.maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performIndex(IndexEntity[][] entities, final IndexEntitiesIndexer indexEntitiesIndexer, final CompassGpsInterfaceDevice compassGps) {
        if (entities.length <= 0) {
            throw new IllegalArgumentException("No entities listed to be indexed, have you defined your entities correctly?");
        }
        int maxThreads = this.maxThreads;
        if (maxThreads == -1) {
            maxThreads = entities.length;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(maxThreads, new NamedThreadFactory("Compass Gps Index", false));
        try {
            List futures;
            ArrayList<1> tasks = new ArrayList<1>();
            for (int i = 0; i < entities.length; ++i) {
                final IndexEntity[] indexEntities = entities[i];
                tasks.add(new Callable(){

                    public Object call() throws Exception {
                        compassGps.executeForIndex(new CompassCallbackWithoutResult(){

                            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                                indexEntitiesIndexer.performIndex(session, indexEntities);
                                session.flush();
                            }
                        });
                        return null;
                    }
                });
            }
            try {
                futures = executorService.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                throw new CompassGpsException("Failed to index, interrupted", e);
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new CompassGpsException("Failed to index, interrupted", e);
                }
                catch (ExecutionException e) {
                    throw new CompassGpsException("Failed to index, execution exception", e);
                    return;
                }
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }
}

