/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem.builder;

import java.util.Iterator;
import org.compass.core.converter.Converter;
import org.compass.core.engine.subindex.ConstantSubIndexHash;
import org.compass.core.engine.subindex.SubIndexHash;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourceMappingProvider;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ManagedId;
import org.compass.core.mapping.osem.builder.SearchableAllMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableAnalyzerMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableBoostMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableCascadeMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableComponentMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableConstantMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableDynamicMetaDataMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableDynamicPropertyMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableIdComponentMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableIdMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableParentMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchablePropertyMappingBuilder;
import org.compass.core.mapping.osem.builder.SearchableReferenceMappingBuilder;
import org.compass.core.util.ClassUtils;

public class SearchableMappingBuilder
implements ResourceMappingProvider {
    private final ClassMapping mapping = new ClassMapping();

    public SearchableMappingBuilder(Class clazz) {
        this.mapping.setClazz(clazz);
        this.mapping.setAlias(ClassUtils.getShortName(clazz));
        this.mapping.setName(clazz.getName());
        this.mapping.setRoot(true);
    }

    public ResourceMapping getMapping() {
        return this.mapping;
    }

    public SearchableMappingBuilder alias(String alias) {
        this.mapping.setAlias(alias);
        return this;
    }

    public SearchableMappingBuilder root(boolean root) {
        this.mapping.setRoot(root);
        return this;
    }

    public SearchableMappingBuilder supportUnmarshall(boolean supportUnmarshall) {
        this.mapping.setSupportUnmarshall(supportUnmarshall);
        return this;
    }

    public SearchableMappingBuilder filterDuplicatesDuringUnmarshalling(boolean filterDuplicatesDuringUnamrshalling) {
        this.mapping.setFilterDuplicates(filterDuplicatesDuringUnamrshalling);
        return this;
    }

    public SearchableMappingBuilder poly(boolean poly) {
        this.mapping.setPoly(poly);
        return this;
    }

    public SearchableMappingBuilder polyClass(Class polyClass) {
        this.mapping.setPolyClass(polyClass);
        return this;
    }

    public SearchableMappingBuilder managedId(ManagedId managedId) {
        this.mapping.setManagedId(managedId);
        return this;
    }

    public SearchableMappingBuilder subIndex(String subIndex) {
        this.mapping.setSubIndexHash(new ConstantSubIndexHash(subIndex));
        return this;
    }

    public SearchableMappingBuilder subIndex(SubIndexHash subIndexHash) {
        this.mapping.setSubIndexHash(subIndexHash);
        return this;
    }

    public SearchableMappingBuilder extendsAliases(String ... extendedAliases) {
        this.mapping.setExtendedAliases(extendedAliases);
        return this;
    }

    public SearchableMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }

    public SearchableMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public SearchableMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public SearchableMappingBuilder all(SearchableAllMappingBuilder builder) {
        this.mapping.setAllMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder mappingConverter(String converter) {
        this.mapping.setConverterName(converter);
        return this;
    }

    public SearchableMappingBuilder mappingConverter(Converter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public SearchableMappingBuilder add(SearchableIdMappingBuilder builder) {
        builder.mapping.setDefinedInAlias(this.mapping.getAlias());
        Iterator<Mapping> it = builder.mapping.mappingsIt();
        while (it.hasNext()) {
            ((ClassPropertyMetaDataMapping)it.next()).setDefinedInAlias(this.mapping.getAlias());
        }
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchablePropertyMappingBuilder builder) {
        builder.mapping.setDefinedInAlias(this.mapping.getAlias());
        Iterator<Mapping> it = builder.mapping.mappingsIt();
        while (it.hasNext()) {
            ((ClassPropertyMetaDataMapping)it.next()).setDefinedInAlias(this.mapping.getAlias());
        }
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchableDynamicPropertyMappingBuilder builder) {
        builder.mapping.setDefinedInAlias(this.mapping.getAlias());
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchableAnalyzerMappingBuilder builder) {
        builder.mapping.setDefinedInAlias(this.mapping.getAlias());
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchableBoostMappingBuilder builder) {
        builder.mapping.setDefinedInAlias(this.mapping.getAlias());
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchableComponentMappingBuilder builder) {
        builder.mapping.setDefinedInAlias(this.mapping.getAlias());
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchableIdComponentMappingBuilder builder) {
        builder.mapping.setDefinedInAlias(this.mapping.getAlias());
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchableReferenceMappingBuilder builder) {
        builder.mapping.setDefinedInAlias(this.mapping.getAlias());
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchableConstantMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchableDynamicMetaDataMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchableCascadeMappingBuilder builder) {
        builder.mapping.setDefinedInAlias(this.mapping.getAlias());
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public SearchableMappingBuilder add(SearchableParentMappingBuilder builder) {
        builder.mapping.setDefinedInAlias(this.mapping.getAlias());
        this.mapping.addMapping(builder.mapping);
        return this;
    }
}

