/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.mt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.transaction.mt.MTTransactionProcessorFactory;
import org.compass.core.lucene.engine.transaction.support.AbstractSearchTransactionProcessor;
import org.compass.core.lucene.engine.transaction.support.CommitCallable;
import org.compass.core.lucene.engine.transaction.support.PrepareCommitCallable;
import org.compass.core.lucene.engine.transaction.support.WriterHelper;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.transaction.context.TransactionalCallable;

public class MTTransactionProcessor
extends AbstractSearchTransactionProcessor {
    private static final Log logger = LogFactory.getLog(MTTransactionProcessor.class);
    private final MTTransactionProcessorFactory transactionProcessorFactory;
    private final Map<String, IndexWriter> indexWriterBySubIndex;

    public MTTransactionProcessor(MTTransactionProcessorFactory transactionProcessorFactory, LuceneSearchEngine searchEngine) {
        super(logger, searchEngine);
        this.transactionProcessorFactory = transactionProcessorFactory;
        this.indexWriterBySubIndex = new ConcurrentHashMap<String, IndexWriter>();
    }

    public String getName() {
        return "mt";
    }

    public void begin() throws SearchEngineException {
    }

    public synchronized void prepare() throws SearchEngineException {
        if (this.indexWriterBySubIndex.isEmpty()) {
            return;
        }
        if (this.indexManager.supportsConcurrentCommits()) {
            ArrayList prepareCallables = new ArrayList();
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                prepareCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new PrepareCommitCallable(entry.getKey(), entry.getValue())));
            }
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(prepareCallables, 1);
        } else {
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                try {
                    new PrepareCommitCallable(entry.getKey(), entry.getValue()).call();
                }
                catch (SearchEngineException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SearchEngineException("Failed to commit transaction for sub index [" + entry.getKey() + "]", e);
                }
            }
        }
    }

    public synchronized void commit(boolean onePhase) throws SearchEngineException {
        if (this.indexWriterBySubIndex.isEmpty()) {
            return;
        }
        if (onePhase) {
            try {
                this.prepare();
            }
            catch (SearchEngineException e) {
                try {
                    this.rollback();
                }
                catch (Exception e1) {
                    logger.trace((Object)"Failed to rollback after prepare failure in one phase commit", (Throwable)e);
                }
                throw e;
            }
        }
        if (this.indexManager.supportsConcurrentCommits()) {
            ArrayList commitCallables = new ArrayList();
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                commitCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new CommitCallable(this.indexManager, entry.getKey(), entry.getValue(), this.isInvalidateCacheOnCommit())));
            }
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(commitCallables, 1);
        } else {
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                try {
                    new CommitCallable(this.indexManager, entry.getKey(), entry.getValue(), this.isInvalidateCacheOnCommit()).call();
                }
                catch (SearchEngineException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SearchEngineException("Failed to commit transaction for sub index [" + entry.getKey() + "]", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws SearchEngineException {
        SearchEngineException exception = null;
        for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
            try {
                entry.getValue().rollback();
            }
            catch (AlreadyClosedException e) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Failed to abort transaction for sub index [" + entry.getKey() + "] since it is alreayd closed"));
            }
            catch (IOException e) {
                Directory dir = this.indexManager.getStore().openDirectory(entry.getKey());
                try {
                    if (IndexWriter.isLocked((Directory)dir)) {
                        IndexWriter.unlock((Directory)dir);
                    }
                }
                catch (Exception e1) {
                    logger.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + entry.getKey() + "]"), (Throwable)e);
                }
                exception = new SearchEngineException("Failed to rollback transaction for sub index [" + entry.getKey() + "]", e);
            }
            finally {
                this.indexManager.getIndexWritersManager().trackCloseIndexWriter(entry.getKey(), entry.getValue());
            }
        }
        this.indexWriterBySubIndex.clear();
        if (exception != null) {
            throw exception;
        }
    }

    public LuceneSearchEngineHits find(LuceneSearchEngineQuery query) throws SearchEngineException {
        return this.performFind(query);
    }

    public Resource[] get(ResourceKey resourceKey) throws SearchEngineException {
        return this.performGet(resourceKey);
    }

    public LuceneSearchEngineInternalSearch internalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        return this.performInternalSearch(subIndexes, aliases);
    }

    public void flush() throws SearchEngineException {
    }

    public void flushCommit(String ... aliases) throws SearchEngineException {
        HashSet<String> calcSubIndexes = new HashSet<String>();
        if (aliases == null || aliases.length == 0) {
            calcSubIndexes.addAll(this.indexWriterBySubIndex.keySet());
        } else {
            Set<String> dirtySubIndxes = this.indexWriterBySubIndex.keySet();
            HashSet<String> requiredSubIndexes = new HashSet<String>(Arrays.asList(this.indexManager.polyCalcSubIndexes(null, aliases, null)));
            for (String subIndex : this.indexManager.getSubIndexes()) {
                if (!dirtySubIndxes.contains(subIndex) || !requiredSubIndexes.contains(subIndex)) continue;
                calcSubIndexes.add(subIndex);
            }
        }
        for (String subIndex : calcSubIndexes) {
            try {
                this.indexWriterBySubIndex.get(subIndex).commit();
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to flush commit sub index [" + subIndex + "]", e);
            }
        }
    }

    public void create(InternalResource resource) throws SearchEngineException {
        try {
            IndexWriter indexWriter = this.getOrCreateIndexWriter(resource.getSubIndex());
            WriterHelper.processCreate(indexWriter, resource);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to create resource [" + resource + "] on sub index [" + resource.getSubIndex() + "]", e);
        }
    }

    public void update(InternalResource resource) throws SearchEngineException {
        try {
            IndexWriter indexWriter = this.getOrCreateIndexWriter(resource.getSubIndex());
            WriterHelper.processUpdate(indexWriter, resource);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to update resource [" + resource + "] on sub index [" + resource.getSubIndex() + "]", e);
        }
    }

    public void delete(ResourceKey resourceKey) throws SearchEngineException {
        try {
            IndexWriter indexWriter = this.getOrCreateIndexWriter(resourceKey.getSubIndex());
            WriterHelper.processDelete(indexWriter, resourceKey);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete resource [" + resourceKey + "] on sub index [" + resourceKey.getSubIndex() + "]", e);
        }
    }

    public void delete(LuceneSearchEngineQuery query) throws SearchEngineException {
        try {
            String[] calcSubIndexes;
            for (String subIndex : calcSubIndexes = this.indexManager.getStore().calcSubIndexes(query.getSubIndexes(), query.getAliases())) {
                IndexWriter indexWriter = this.getOrCreateIndexWriter(subIndex);
                WriterHelper.processDelete(indexWriter, query.getQuery());
            }
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete query [" + query + "]", e);
        }
    }

    protected IndexWriter getOrCreateIndexWriter(final String subIndex) throws SearchEngineException {
        IndexWriter indexWriter = this.indexWriterBySubIndex.get(subIndex);
        if (indexWriter != null) {
            return indexWriter;
        }
        try {
            return this.transactionProcessorFactory.doUnderIndexWriterLock(subIndex, new Callable<IndexWriter>(){

                @Override
                public IndexWriter call() throws Exception {
                    IndexWriter indexWriter = (IndexWriter)MTTransactionProcessor.this.indexWriterBySubIndex.get(subIndex);
                    if (indexWriter != null) {
                        return indexWriter;
                    }
                    indexWriter = MTTransactionProcessor.this.indexManager.getIndexWritersManager().openIndexWriter(MTTransactionProcessor.this.searchEngine.getSettings(), subIndex);
                    MTTransactionProcessor.this.indexWriterBySubIndex.put(subIndex, indexWriter);
                    MTTransactionProcessor.this.indexManager.getIndexWritersManager().trackOpenIndexWriter(subIndex, indexWriter);
                    return indexWriter;
                }
            });
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to open index writer for sub index [" + subIndex + "]", e);
        }
    }
}

