/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.transaction.support.AbstractConcurrentTransactionProcessor;
import org.compass.core.lucene.engine.transaction.support.CommitCallable;
import org.compass.core.lucene.engine.transaction.support.PrepareCommitCallable;
import org.compass.core.lucene.engine.transaction.support.job.TransactionJob;
import org.compass.core.spi.ResourceKey;
import org.compass.core.transaction.context.TransactionalCallable;

public class LuceneTransactionProcessor
extends AbstractConcurrentTransactionProcessor {
    private static final Log logger = LogFactory.getLog(LuceneTransactionProcessor.class);
    private Map<String, IndexWriter> indexWriterBySubIndex = this.isConcurrentOperations() ? new ConcurrentHashMap<String, IndexWriter>() : new HashMap<String, IndexWriter>();

    public LuceneTransactionProcessor(LuceneSearchEngine searchEngine) {
        super(logger, searchEngine, false, searchEngine.getSearchEngineFactory().getIndexManager().supportsConcurrentOperations());
    }

    public String getName() {
        return "lucene";
    }

    protected String[] getDirtySubIndexes() {
        return this.indexWriterBySubIndex.keySet().toArray(new String[this.indexWriterBySubIndex.keySet().size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRollback() throws SearchEngineException {
        SearchEngineException exception = null;
        for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
            try {
                entry.getValue().rollback();
            }
            catch (AlreadyClosedException e) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Failed to abort transaction for sub index [" + entry.getKey() + "] since it is alreayd closed"));
            }
            catch (IOException e) {
                Directory dir = this.indexManager.getStore().openDirectory(entry.getKey());
                try {
                    if (IndexWriter.isLocked((Directory)dir)) {
                        IndexWriter.unlock((Directory)dir);
                    }
                }
                catch (Exception e1) {
                    logger.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + entry.getKey() + "]"), (Throwable)e);
                }
                exception = new SearchEngineException("Failed to rollback transaction for sub index [" + entry.getKey() + "]", e);
            }
            finally {
                this.indexManager.getIndexWritersManager().trackCloseIndexWriter(entry.getKey(), entry.getValue());
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void doPrepare() throws SearchEngineException {
        if (this.indexWriterBySubIndex.isEmpty()) {
            return;
        }
        if (this.indexManager.supportsConcurrentCommits()) {
            ArrayList prepareCallables = new ArrayList();
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                prepareCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new PrepareCommitCallable(entry.getKey(), entry.getValue())));
            }
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(prepareCallables, 1);
        } else {
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                try {
                    new PrepareCommitCallable(entry.getKey(), entry.getValue()).call();
                }
                catch (SearchEngineException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SearchEngineException("Failed to commit transaction for sub index [" + entry.getKey() + "]", e);
                }
            }
        }
    }

    protected void doCommit(boolean onePhase) throws SearchEngineException {
        if (this.indexWriterBySubIndex.isEmpty()) {
            return;
        }
        if (onePhase) {
            try {
                this.prepare();
            }
            catch (SearchEngineException e) {
                try {
                    this.rollback();
                }
                catch (Exception e1) {
                    logger.trace((Object)"Failed to rollback after prepare failure in one phase commit", (Throwable)e);
                }
                throw e;
            }
        }
        if (this.indexManager.supportsConcurrentCommits()) {
            ArrayList commitCallables = new ArrayList();
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                commitCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new CommitCallable(this.indexManager, entry.getKey(), entry.getValue(), this.isInvalidateCacheOnCommit())));
            }
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(commitCallables, 1);
        } else {
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                try {
                    new CommitCallable(this.indexManager, entry.getKey(), entry.getValue(), this.isInvalidateCacheOnCommit()).call();
                }
                catch (SearchEngineException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SearchEngineException("Failed to commit transaction for sub index [" + entry.getKey() + "]", e);
                }
            }
        }
    }

    protected void doProcessJob(TransactionJob job) throws SearchEngineException {
        try {
            IndexWriter indexWriter = this.getOrCreateIndexWriter(job.getSubIndex());
            job.execute(indexWriter, this.searchEngineFactory);
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to execeute job [" + job + "]", e);
        }
    }

    protected LuceneSearchEngineHits doFind(LuceneSearchEngineQuery query) throws SearchEngineException {
        return this.performFind(query);
    }

    protected LuceneSearchEngineInternalSearch doInternalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        return this.performInternalSearch(subIndexes, aliases);
    }

    protected Resource[] doGet(ResourceKey resourceKey) throws SearchEngineException {
        return this.performGet(resourceKey);
    }

    protected void prepareBeforeAsyncDirtyOperation(TransactionJob job) throws SearchEngineException {
        try {
            this.getOrCreateIndexWriter(job.getSubIndex());
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open index writer for sub index [" + job.getSubIndex() + "]", e);
        }
    }

    protected IndexWriter getOrCreateIndexWriter(String subIndex) throws IOException {
        IndexWriter indexWriter = this.indexWriterBySubIndex.get(subIndex);
        if (indexWriter != null) {
            return indexWriter;
        }
        indexWriter = this.indexManager.getIndexWritersManager().openIndexWriter(this.searchEngine.getSettings(), subIndex);
        this.indexWriterBySubIndex.put(subIndex, indexWriter);
        this.indexManager.getIndexWritersManager().trackOpenIndexWriter(subIndex, indexWriter);
        return indexWriter;
    }
}

