/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LuceneUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.DirectoryWrapper;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.store.CopyFromHolder;
import org.compass.core.lucene.engine.store.DirectoryStore;
import org.compass.core.lucene.engine.store.FSDirectoryStore;
import org.compass.core.lucene.engine.store.JdbcDirectoryStore;
import org.compass.core.lucene.engine.store.LockFactoryProvider;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.MMapDirectoryStore;
import org.compass.core.lucene.engine.store.NIOFSDirectoryStore;
import org.compass.core.lucene.engine.store.RAMDirectoryStore;
import org.compass.core.lucene.engine.store.localcache.LocalCacheManager;
import org.compass.core.lucene.engine.store.wrapper.DirectoryWrapperProvider;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.StringUtils;

public class DefaultLuceneSearchEngineStore
implements LuceneSearchEngineStore {
    private static Log log = LogFactory.getLog(DefaultLuceneSearchEngineStore.class);
    private final CompassMapping mapping;
    private final CompassSettings settings;
    private final DirectoryStore directoryStore;
    private final Map<String, List<String>> aliasesBySubIndex = new HashMap<String, List<String>>();
    private final Map<String, List<String>> subIndexesByAlias = new HashMap<String, List<String>>();
    private final String defaultSubContext;
    private final String[] subIndexes;
    private final Set<String> subIndexesSet;
    private final String connectionString;
    private final DirectoryWrapperProvider[] directoryWrapperProviders;
    private final LocalCacheManager localCacheManager;
    private final Map<String, Map<String, Directory>> dirs;
    private final boolean useCompoundFile;
    private final boolean supportsConcurrentOperations;
    private final boolean supportsConcurrentCommits;
    private volatile boolean closed = false;

    public DefaultLuceneSearchEngineStore(LuceneSearchEngineFactory searchEngineFactory, CompassSettings settings, CompassMapping mapping) {
        String useConcurrentOperationsSetting;
        String useCompoundFileSetting;
        this.settings = settings;
        this.mapping = mapping;
        this.connectionString = settings.getSetting("compass.engine.connection");
        this.dirs = new ConcurrentHashMap<String, Map<String, Directory>>();
        this.defaultSubContext = settings.getSetting("compass.engine.connection.subContext", "index");
        String connection = settings.getSetting("compass.engine.connection");
        if (connection.startsWith("ram://")) {
            this.directoryStore = new RAMDirectoryStore();
        } else if (connection.startsWith("file://")) {
            this.directoryStore = new FSDirectoryStore();
        } else if (connection.startsWith("mmap://")) {
            this.directoryStore = new MMapDirectoryStore();
        } else if (connection.startsWith("niofs://")) {
            this.directoryStore = new NIOFSDirectoryStore();
        } else if (connection.startsWith("jdbc://")) {
            this.directoryStore = new JdbcDirectoryStore();
        } else {
            if (connection.indexOf("://") > -1) {
                Properties props;
                String pluggableStore = connection.substring(0, connection.indexOf("://"));
                InputStream is = LuceneSearchEngineStore.class.getResourceAsStream("/META-INF/compass/store-" + pluggableStore + ".properties");
                try {
                    props = new Properties();
                    props.load(is);
                }
                catch (Exception e) {
                    try {
                        is.close();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    throw new SearchEngineException("Failed to create store [" + connection + "]", e);
                }
                String className = props.getProperty("type");
                try {
                    this.directoryStore = (DirectoryStore)ClassUtils.forName(className, settings.getClassLoader()).newInstance();
                }
                catch (Exception e) {
                    throw new SearchEngineException("Failed to create connection [" + connection + "]", e);
                }
            }
            this.directoryStore = new FSDirectoryStore();
        }
        if (this.directoryStore instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)this.directoryStore)).configure(settings);
        }
        this.useCompoundFile = (useCompoundFileSetting = settings.getSetting("compass.engine.useCompoundFile")) == null ? this.directoryStore.suggestedUseCompoundFile() : Boolean.valueOf(useCompoundFileSetting).booleanValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using compound format [" + this.useCompoundFile + "]"));
        }
        this.supportsConcurrentOperations = (useConcurrentOperationsSetting = settings.getSetting("compass.engine.useConcurrentOperations")) == null ? this.directoryStore.supportsConcurrentOperations() : Boolean.valueOf(useConcurrentOperationsSetting).booleanValue();
        String useConcurrentCommitsSetting = settings.getSetting("compass.engine.useConcurrentCommits");
        this.supportsConcurrentCommits = useConcurrentCommitsSetting == null ? this.directoryStore.supportsConcurrentCommits() : Boolean.valueOf(useConcurrentCommitsSetting).booleanValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Support concurrent operations [" + this.supportsConcurrentOperations + "] and concurrent commits [" + this.supportsConcurrentCommits + "]"));
        }
        this.subIndexesSet = new HashSet<String>();
        for (ResourceMapping resourceMapping : mapping.getRootMappings()) {
            String[] tempSubIndexes;
            String alias = resourceMapping.getAlias();
            for (String subIndex : tempSubIndexes = resourceMapping.getSubIndexHash().getSubIndexes()) {
                this.subIndexesSet.add(subIndex.intern());
                List<String> list = this.subIndexesByAlias.get(alias);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.subIndexesByAlias.put(alias, list);
                }
                list.add(subIndex);
                list = this.aliasesBySubIndex.get(subIndex);
                if (this.aliasesBySubIndex.get(subIndex) == null) {
                    list = new ArrayList<String>();
                    this.aliasesBySubIndex.put(subIndex, list);
                }
                list.add(alias);
            }
        }
        this.subIndexes = this.subIndexesSet.toArray(new String[this.subIndexesSet.size()]);
        DirectoryWrapperProvider[] directoryWrapperProviders = null;
        Map<String, CompassSettings> dwSettingGroups = settings.getSettingGroups("compass.engine.store.wrapper");
        if (dwSettingGroups.size() > 0) {
            ArrayList<DirectoryWrapperProvider> dws = new ArrayList<DirectoryWrapperProvider>();
            for (Map.Entry<String, CompassSettings> entry : dwSettingGroups.entrySet()) {
                DirectoryWrapperProvider dw;
                CompassSettings dwSettings;
                String dwType;
                String dwName = entry.getKey();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Building directory wrapper [" + dwName + "]"));
                }
                if ((dwType = (dwSettings = entry.getValue()).getSetting("type")) == null) {
                    throw new ConfigurationException("Directory wrapper [" + dwName + "] has no type associated with it");
                }
                try {
                    dw = (DirectoryWrapperProvider)ClassUtils.forName(dwType, settings.getClassLoader()).newInstance();
                }
                catch (Exception e) {
                    throw new ConfigurationException("Failed to create directory wrapper [" + dwName + "]", e);
                }
                if (dw instanceof CompassConfigurable) {
                    ((CompassConfigurable)((Object)dw)).configure(dwSettings);
                }
                dws.add(dw);
            }
            directoryWrapperProviders = dws.toArray(new DirectoryWrapperProvider[dws.size()]);
        }
        this.directoryWrapperProviders = directoryWrapperProviders;
        this.localCacheManager = new LocalCacheManager(searchEngineFactory);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.localCacheManager.close();
        this.closeDirectories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDirectories() {
        Iterator<Map<String, Directory>> i$ = this.dirs.values().iterator();
        while (i$.hasNext()) {
            Map<String, Directory> subIndexsDirs;
            Map<String, Directory> map = subIndexsDirs = i$.next();
            synchronized (map) {
                for (Directory dir : subIndexsDirs.values()) {
                    try {
                        dir.close();
                    }
                    catch (IOException e) {
                        log.debug((Object)"Failed to close directory while shutting down, ignoring", (Throwable)e);
                    }
                }
            }
        }
        this.dirs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performScheduledTasks() {
        for (Map.Entry<String, Map<String, Directory>> entry : this.dirs.entrySet()) {
            String subContext = entry.getKey();
            Map<String, Directory> map = entry.getValue();
            synchronized (map) {
                for (Map.Entry<String, Directory> entry2 : entry.getValue().entrySet()) {
                    String subIndex = entry2.getKey();
                    Directory dir = entry2.getValue();
                    this.directoryStore.performScheduledTasks(this.unwrapDir(dir), subContext, subIndex);
                }
            }
        }
    }

    public String[] getAliasesBySubIndex(String subIndex) {
        List<String> aliasesPerSubIndex = this.aliasesBySubIndex.get(subIndex);
        return aliasesPerSubIndex.toArray(new String[aliasesPerSubIndex.size()]);
    }

    public int getNumberOfAliasesBySubIndex(String subIndex) {
        return this.aliasesBySubIndex.get(subIndex).size();
    }

    public String[] getSubIndexes() {
        return this.subIndexes;
    }

    public boolean subIndexExists(String subIndex) {
        return this.subIndexesSet.contains(subIndex);
    }

    public String[] calcSubIndexes(String[] subIndexes, String[] aliases, Class[] types) {
        return this.internalCalcSubIndexes(subIndexes, aliases, types, false);
    }

    public String[] polyCalcSubIndexes(String[] subIndexes, String[] aliases, Class[] types) {
        return this.internalCalcSubIndexes(subIndexes, aliases, types, true);
    }

    public String[] internalCalcSubIndexes(String[] subIndexes, String[] aliases, Class[] types, boolean poly) {
        ResourceMapping resourceMapping;
        if (aliases == null && types == null) {
            return this.calcSubIndexes(subIndexes, aliases);
        }
        HashSet<String> aliasesSet = new HashSet<String>();
        if (aliases != null) {
            for (String alias : aliases) {
                resourceMapping = this.mapping.getRootMappingByAlias(alias);
                if (resourceMapping == null) {
                    throw new IllegalArgumentException("No root mapping found for alias [" + (String)alias + "]");
                }
                aliasesSet.add(resourceMapping.getAlias());
                if (!poly) continue;
                aliasesSet.addAll(Arrays.asList(resourceMapping.getExtendingAliases()));
            }
        }
        if (types != null) {
            for (Class type : types) {
                resourceMapping = this.mapping.getRootMappingByClass(type);
                if (resourceMapping == null) {
                    throw new IllegalArgumentException("No root mapping found for class [" + type + "]");
                }
                aliasesSet.add(resourceMapping.getAlias());
                if (!poly) continue;
                aliasesSet.addAll(Arrays.asList(resourceMapping.getExtendingAliases()));
            }
        }
        return this.calcSubIndexes(subIndexes, aliasesSet.toArray(new String[aliasesSet.size()]));
    }

    public String[] calcSubIndexes(String[] subIndexes, String[] aliases) {
        if (aliases == null) {
            if (subIndexes == null) {
                return this.getSubIndexes();
            }
            HashSet<String> ret = new HashSet<String>();
            ret.addAll(Arrays.asList(subIndexes));
            return ret.toArray(new String[ret.size()]);
        }
        HashSet<String> ret = new HashSet<String>();
        for (String aliase : aliases) {
            List<String> subIndexesList = this.subIndexesByAlias.get(aliase);
            if (subIndexesList == null) {
                throw new IllegalArgumentException("No sub-index is mapped to alias [" + aliase + "]");
            }
            for (String subIndex : subIndexesList) {
                ret.add(subIndex);
            }
        }
        if (subIndexes != null) {
            ret.addAll(Arrays.asList(subIndexes));
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Directory openDirectory(String subIndex) throws SearchEngineException {
        return this.openDirectory(this.defaultSubContext, subIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory openDirectory(String subContext, String subIndex) throws SearchEngineException {
        Directory dir;
        Map<String, Directory> subContextDirs = this.dirs.get(subContext);
        if (subContextDirs == null) {
            subContextDirs = new ConcurrentHashMap<String, Directory>();
            this.dirs.put(subContext, subContextDirs);
        }
        if ((dir = subContextDirs.get(subIndex)) != null) {
            return dir;
        }
        Map<String, Directory> map = subContextDirs;
        synchronized (map) {
            dir = subContextDirs.get(subIndex);
            if (dir != null) {
                return dir;
            }
            dir = this.directoryStore.open(subContext, subIndex);
            Object lockFactoryType = this.settings.getSettingAsObject("compass.engine.store.lockFactory.type");
            if (lockFactoryType != null) {
                NativeFSLockFactory lockFactory;
                String lockDir;
                String path = this.settings.getSetting("compass.engine.store.lockFactory.path");
                if (path != null) {
                    path = StringUtils.replace(path, "#subindex#", subIndex);
                    path = StringUtils.replace(path, "#subContext#", subContext);
                }
                if (lockFactoryType instanceof String && "nativefs".equalsIgnoreCase((String)lockFactoryType)) {
                    lockDir = path;
                    if (lockDir == null && (lockDir = this.connectionString + "/" + subContext + "/" + subIndex).startsWith("file://")) {
                        lockDir = lockDir.substring("file://".length());
                    }
                    try {
                        lockFactory = new NativeFSLockFactory(lockDir);
                    }
                    catch (IOException e) {
                        throw new SearchEngineException("Failed to create native fs lock factory with lock dir [" + lockDir + "]", e);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using native fs lock for sub index [" + subIndex + "] and lock directory [" + lockDir + "]"));
                    }
                } else if (lockFactoryType instanceof String && "simplefs".equalsIgnoreCase((String)lockFactoryType)) {
                    lockDir = path;
                    if (lockDir == null && (lockDir = this.connectionString + "/" + subContext + "/" + subIndex).startsWith("file://")) {
                        lockDir = lockDir.substring("file://".length());
                    }
                    try {
                        lockFactory = new SimpleFSLockFactory(lockDir);
                    }
                    catch (IOException e) {
                        throw new SearchEngineException("Failed to create simple fs lock factory with lock dir [" + lockDir + "]", e);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using simple fs lock for sub index [" + subIndex + "] and lock directory [" + lockDir + "]"));
                    }
                } else if (lockFactoryType instanceof String && "singleinstance".equalsIgnoreCase((String)lockFactoryType)) {
                    lockFactory = new SingleInstanceLockFactory();
                } else if (lockFactoryType instanceof String && "nolock".equalsIgnoreCase((String)lockFactoryType)) {
                    lockFactory = new NoLockFactory();
                } else {
                    Object temp;
                    if (lockFactoryType instanceof String) {
                        try {
                            temp = ClassUtils.forName((String)lockFactoryType, this.settings.getClassLoader()).newInstance();
                        }
                        catch (Exception e) {
                            throw new SearchEngineException("Failed to create lock type [" + lockFactoryType + "]", e);
                        }
                    } else {
                        temp = lockFactoryType;
                    }
                    if (temp instanceof LockFactory) {
                        lockFactory = (LockFactory)temp;
                    } else if (temp instanceof LockFactoryProvider) {
                        lockFactory = ((LockFactoryProvider)temp).createLockFactory(path, subContext, subIndex, this.settings);
                    } else {
                        throw new SearchEngineException("No specific type of lock factory");
                    }
                    if (lockFactory instanceof CompassConfigurable) {
                        ((CompassConfigurable)lockFactory).configure(this.settings);
                    }
                }
                dir.setLockFactory((LockFactory)lockFactory);
            }
            if (this.directoryWrapperProviders != null) {
                for (DirectoryWrapperProvider directoryWrapperProvider : this.directoryWrapperProviders) {
                    dir = directoryWrapperProvider.wrap(subIndex, dir);
                }
            }
            if (!this.closed) {
                dir = this.localCacheManager.createLocalCache(subContext, subIndex, dir);
            }
            subContextDirs.put(subIndex, dir);
        }
        return dir;
    }

    public synchronized boolean indexExists() throws SearchEngineException {
        for (String subIndex : this.subIndexes) {
            if (this.indexExists(subIndex)) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean indexExists(String subIndex) throws SearchEngineException {
        return this.indexExists(this.defaultSubContext, subIndex);
    }

    public synchronized boolean indexExists(String subContext, String subIndex) throws SearchEngineException {
        boolean closeDir = !this.directoryExists(subContext, subIndex);
        Directory dir = this.openDirectory(subContext, subIndex);
        Boolean retVal = this.directoryStore.indexExists(this.unwrapDir(dir));
        if (retVal != null) {
            return retVal;
        }
        try {
            retVal = IndexReader.indexExists((Directory)dir);
        }
        catch (IOException e) {
            return false;
        }
        if (closeDir) {
            this.closeDirectory(dir, subContext, subIndex);
        }
        return retVal;
    }

    public synchronized void createIndex() throws SearchEngineException {
        for (String subIndex : this.subIndexes) {
            this.createIndex(subIndex);
        }
    }

    public synchronized void createIndex(String subIndex) throws SearchEngineException {
        this.createIndex(this.defaultSubContext, subIndex);
    }

    public synchronized void createIndex(String subContext, String subIndex) throws SearchEngineException {
        Directory dir = this.openDirectory(subContext, subIndex);
        try {
            IndexWriter indexWriter = new IndexWriter(dir, (Analyzer)new StandardAnalyzer(), true);
            indexWriter.close();
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to create index for sub index [" + subIndex + "]", e);
        }
    }

    public synchronized void deleteIndex() throws SearchEngineException {
        for (String subIndex : this.subIndexes) {
            this.deleteIndex(subIndex);
        }
    }

    public synchronized void deleteIndex(String subIndex) throws SearchEngineException {
        this.deleteIndex(this.defaultSubContext, subIndex);
    }

    public synchronized void deleteIndex(String subContext, String subIndex) throws SearchEngineException {
        Directory dir = this.openDirectory(subContext, subIndex);
        this.directoryStore.deleteIndex(this.unwrapDir(dir), subContext, subIndex);
        this.closeDirectory(dir, subContext, subIndex);
    }

    public synchronized boolean verifyIndex() throws SearchEngineException {
        boolean createdIndex = false;
        for (String subIndex : this.subIndexes) {
            if (!this.verifyIndex(subIndex)) continue;
            createdIndex = true;
        }
        return createdIndex;
    }

    public synchronized boolean verifyIndex(String subIndex) throws SearchEngineException {
        return this.verifyIndex(this.defaultSubContext, subIndex);
    }

    public synchronized boolean verifyIndex(String subContext, String subIndex) throws SearchEngineException {
        if (!this.indexExists(subContext, subIndex)) {
            this.createIndex(subContext, subIndex);
            return true;
        }
        return false;
    }

    public synchronized void cleanIndex(String subIndex) throws SearchEngineException {
        this.cleanIndex(this.defaultSubContext, subIndex);
    }

    public synchronized void cleanIndex(String subContext, String subIndex) throws SearchEngineException {
        Directory dir = this.directoryStore.open(subContext, subIndex);
        Directory unwrapDir = this.unwrapDir(dir);
        this.directoryStore.cleanIndex(unwrapDir, subContext, subIndex);
        this.closeDirectory(dir, subContext, subIndex);
        this.createIndex(subContext, subIndex);
    }

    public synchronized boolean isLocked() throws SearchEngineException {
        for (String subIndex : this.getSubIndexes()) {
            if (!this.isLocked(subIndex)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isLocked(String subIndex) throws SearchEngineException {
        return this.isLocked(this.defaultSubContext, subIndex);
    }

    public synchronized boolean isLocked(String subContext, String subIndex) throws SearchEngineException {
        try {
            return IndexReader.isLocked((Directory)this.openDirectory(subContext, subIndex));
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to check if index is locked for sub context [" + subContext + "] and sub index [" + subIndex + "]", e);
        }
    }

    public synchronized void releaseLocks() throws SearchEngineException {
        for (String subIndex : this.subIndexes) {
            this.releaseLock(subIndex);
        }
    }

    public synchronized void releaseLock(String subIndex) throws SearchEngineException {
        this.releaseLock(this.defaultSubContext, subIndex);
    }

    public synchronized void releaseLock(String subContext, String subIndex) throws SearchEngineException {
        try {
            IndexWriter.unlock((Directory)this.openDirectory(subContext, subIndex));
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to unlock index for sub context [" + subContext + "] and sub index [" + subIndex + "]", e);
        }
    }

    public void copyFrom(String subIndex, LuceneSearchEngineStore searchEngineStore) throws SearchEngineException {
        this.copyFrom(this.defaultSubContext, subIndex, searchEngineStore);
    }

    public void copyFrom(String subContext, String subIndex, LuceneSearchEngineStore searchEngineStore) throws SearchEngineException {
        Directory dir = this.openDirectory(subContext, subIndex);
        Directory unwrappedDir = this.unwrapDir(dir);
        if (dir instanceof DirectoryWrapper) {
            try {
                ((DirectoryWrapper)dir).clearWrapper();
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to clear wrapper for sub index [" + subIndex + "]", e);
            }
        }
        CopyFromHolder holder = this.directoryStore.beforeCopyFrom(subContext, subIndex, unwrappedDir);
        byte[] buffer = new byte[32768];
        try {
            Directory dest = this.openDirectory(subContext, subIndex);
            Directory src = searchEngineStore.openDirectory(subIndex);
            LuceneUtils.copy(src, dest, buffer);
            if (!IndexReader.indexExists((Directory)dest)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Copy From sub context [" + subContext + "] and sub index [" + subIndex + "] does not contain data, creating empty index"));
                }
                IndexWriter writer = new IndexWriter(dest, (Analyzer)new StandardAnalyzer(), true);
                writer.close();
            }
        }
        catch (Exception e) {
            this.directoryStore.afterFailedCopyFrom(subContext, subIndex, holder);
            if (e instanceof SearchEngineException) {
                throw (SearchEngineException)e;
            }
            throw new SearchEngineException("Failed to copy from " + searchEngineStore, e);
        }
        this.directoryStore.afterSuccessfulCopyFrom(subContext, subIndex, holder);
    }

    public void registerEventListeners(SearchEngine searchEngine, SearchEngineEventManager eventManager) {
        this.directoryStore.registerEventListeners(searchEngine, eventManager);
    }

    public boolean requiresAsyncTransactionalContext() {
        return this.directoryStore.requiresAsyncTransactionalContext();
    }

    public boolean supportsConcurrentOperations() {
        return this.supportsConcurrentOperations;
    }

    public boolean supportsConcurrentCommits() {
        return this.supportsConcurrentCommits;
    }

    public boolean isUseCompoundFile() {
        return this.useCompoundFile;
    }

    public String suggestedIndexDeletionPolicy() {
        return this.directoryStore.suggestedIndexDeletionPolicy();
    }

    public String getDefaultSubContext() {
        return this.defaultSubContext;
    }

    private boolean directoryExists(String subContext, String subIndex) throws SearchEngineException {
        Map<String, Directory> subContextDirs = this.dirs.get(subContext);
        return subContextDirs != null && subContextDirs.containsKey(subIndex);
    }

    private void closeDirectory(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        this.directoryStore.closeDirectory(dir, subContext, subIndex);
        Map<String, Directory> subContextDirs = this.dirs.get(subContext);
        if (subContextDirs != null) {
            subContextDirs.remove(subIndex);
        }
    }

    private Directory unwrapDir(Directory dir) {
        while (dir instanceof DirectoryWrapper) {
            dir = ((DirectoryWrapper)dir).getWrappedDirectory();
        }
        return dir;
    }

    public String toString() {
        return "store [" + this.connectionString + "][" + this.defaultSubContext + "] sub-indexes [" + StringUtils.arrayToCommaDelimitedString(this.subIndexes) + "]";
    }
}

