/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.manager;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.compass.core.config.CompassSettings;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.merge.policy.MergePolicyFactory;
import org.compass.core.lucene.engine.merge.scheduler.MergeSchedulerFactory;

public class IndexWritersManager {
    private static final Log logger = LogFactory.getLog(IndexWritersManager.class);
    private final LuceneSearchEngineIndexManager indexManager;
    private final LuceneSearchEngineFactory searchEngineFactory;
    private LuceneSettings luceneSettings;
    private final ConcurrentMap<String, IndexWriter> trackedOpenIndexWriters;
    private final boolean trackOpenIndexWriters;

    public IndexWritersManager(LuceneSearchEngineIndexManager indexManager) {
        this.indexManager = indexManager;
        this.searchEngineFactory = indexManager.getSearchEngineFactory();
        this.luceneSettings = indexManager.getSettings();
        boolean bl = this.trackOpenIndexWriters = this.luceneSettings.getSettings().getSettingAsBoolean("compass.engine.trackOpenedIndexWriters", true) || indexManager.getSearchEngineFactory().isDebug();
        if (this.trackOpenIndexWriters) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Tracking open index writers");
            }
            this.trackedOpenIndexWriters = new ConcurrentHashMap<String, IndexWriter>();
        } else {
            this.trackedOpenIndexWriters = null;
        }
    }

    public void close() {
        if (this.trackOpenIndexWriters) {
            for (Map.Entry entry : this.trackedOpenIndexWriters.entrySet()) {
                logger.error((Object)("[INDEX WRITER] Sub Index [" + (String)entry.getKey() + "] is still open, rolling back"));
                try {
                    ((IndexWriter)entry.getValue()).rollback();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void trackOpenIndexWriter(String subIndex, IndexWriter indexWriter) {
        IndexWriter oldValue;
        if (this.trackOpenIndexWriters && (oldValue = this.trackedOpenIndexWriters.put(subIndex, indexWriter)) != null) {
            logger.error((Object)("Illegal state, marking an index writer as open, while another is marked as open for sub index [" + subIndex + "]"));
        }
    }

    public void trackCloseIndexWriter(String subIndex, IndexWriter indexWriter) {
        if (this.trackOpenIndexWriters) {
            IndexWriter value = (IndexWriter)this.trackedOpenIndexWriters.remove(subIndex);
            if (value == null) {
                logger.error((Object)("Illegal state, marking an index writer as closed, but none was opened before (or closed twice) for sub index [" + subIndex + "]"));
            } else if (value != indexWriter) {
                logger.error((Object)("Illegal state, marking an index writer as closed, but a different was opened before for sub index [" + subIndex + "]"));
            }
        }
    }

    public IndexWriter openIndexWriter(CompassSettings settings, String subIndex) throws IOException {
        return this.openIndexWriter(settings, this.indexManager.getDirectory(subIndex), false);
    }

    public IndexWriter openIndexWriter(CompassSettings settings, Directory dir, boolean create) throws IOException {
        return this.openIndexWriter(settings, dir, create, null);
    }

    public IndexWriter openIndexWriter(CompassSettings settings, Directory dir, IndexDeletionPolicy deletionPolicy) throws IOException {
        return this.openIndexWriter(settings, dir, false, deletionPolicy);
    }

    public IndexWriter openIndexWriter(CompassSettings settings, Directory dir, boolean create, IndexDeletionPolicy deletionPolicy) throws IOException {
        return this.openIndexWriter(settings, dir, create, deletionPolicy, null);
    }

    public IndexWriter openIndexWriter(CompassSettings settings, Directory dir, boolean create, IndexDeletionPolicy deletionPolicy, Analyzer analyzer) throws IOException {
        if (deletionPolicy == null) {
            deletionPolicy = this.searchEngineFactory.getIndexDeletionPolicyManager().createIndexDeletionPolicy(dir);
        }
        if (analyzer == null) {
            analyzer = this.searchEngineFactory.getAnalyzerManager().getDefaultAnalyzer();
        }
        IndexWriter indexWriter = new IndexWriter(dir, analyzer, create, deletionPolicy, new IndexWriter.MaxFieldLength(this.luceneSettings.getMaxFieldLength()));
        indexWriter.setMergePolicy(MergePolicyFactory.createMergePolicy(settings));
        indexWriter.setMergeScheduler(MergeSchedulerFactory.create(this.indexManager, settings));
        indexWriter.setMaxMergeDocs(settings.getSettingAsInt("compass.engine.maxMergeDocs", this.luceneSettings.getMaxMergeDocs()));
        indexWriter.setMergeFactor(settings.getSettingAsInt("compass.engine.mergeFactor", this.luceneSettings.getMergeFactor()));
        indexWriter.setRAMBufferSizeMB(settings.getSettingAsDouble("compass.engine.ramBufferSize", this.luceneSettings.getRamBufferSize()));
        indexWriter.setMaxBufferedDocs(settings.getSettingAsInt("compass.engine.maxBufferedDocs", this.luceneSettings.getMaxBufferedDocs()));
        indexWriter.setMaxBufferedDeleteTerms(settings.getSettingAsInt("compass.engine.maxBufferedDeletedTerms", this.luceneSettings.getMaxBufferedDeletedTerms()));
        indexWriter.setUseCompoundFile(this.indexManager.getStore().isUseCompoundFile());
        indexWriter.setMaxFieldLength(this.luceneSettings.getMaxFieldLength());
        indexWriter.setTermIndexInterval(this.luceneSettings.getTermIndexInterval());
        indexWriter.setSimilarity(this.searchEngineFactory.getSimilarityManager().getIndexSimilarity());
        return indexWriter;
    }
}

