/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.executor.DummyFuture;
import org.compass.core.executor.ExecutorException;
import org.compass.core.executor.ExecutorManager;
import org.compass.core.executor.concurrent.ConcurrentExecutorManager;
import org.compass.core.executor.spi.InternalExecutorManager;
import org.compass.core.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecutorManager
implements ExecutorManager,
CompassConfigurable {
    private InternalExecutorManager executorManager;

    @Override
    public void configure(CompassSettings settings) throws CompassException {
        String executorManagerType = settings.getSetting("compass.executorManager.type", ConcurrentExecutorManager.class.getName());
        if (executorManagerType.equals("concurrent")) {
            executorManagerType = ConcurrentExecutorManager.class.getName();
        } else if (executorManagerType.equals("scheduled")) {
            executorManagerType = ScheduledExecutorService.class.getName();
        } else if (executorManagerType.equals("workManager")) {
            executorManagerType = "org.compass.core.executor.workmanager.WorkManagerExecutorManager";
        } else if (executorManagerType.equals("commonj")) {
            executorManagerType = "org.compass.core.executor.commonj.WorkManagerExecutorManager";
        }
        try {
            this.executorManager = (InternalExecutorManager)ClassUtils.forName(executorManagerType, settings.getClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create executor manager [" + executorManagerType + "]", e);
        }
        if (this.executorManager instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)this.executorManager)).configure(settings);
        }
    }

    @Override
    public <T> List<Future<T>> invokeAllWithLimitBailOnException(Collection<Callable<T>> tasks, int concurrencyThreshold) {
        List<Future<T>> futures = this.invokeAllWithLimit(tasks, concurrencyThreshold);
        for (Future<T> future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new ExecutorException("Failed to execute, interrupted", e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof CompassException) {
                    throw (CompassException)e.getCause();
                }
                throw new ExecutorException("Failed to execute", e.getCause());
            }
        }
        return futures;
    }

    @Override
    public <T> List<Future<T>> invokeAllWithLimit(Collection<Callable<T>> tasks, int concurrencyThreshold) {
        ArrayList<Future<T>> futures;
        if (tasks.size() == 0) {
            return new ArrayList<Future<T>>(0);
        }
        if (tasks.size() > concurrencyThreshold) {
            try {
                futures = this.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                throw new ExecutorException("Interrupted while executing tasks", e);
            }
        } else {
            futures = new ArrayList();
            for (Callable<T> commit : tasks) {
                try {
                    futures.add(new DummyFuture<T>(commit.call()));
                }
                catch (Exception e) {
                    futures.add(new DummyFuture(e));
                }
            }
        }
        return futures;
    }

    @Override
    public void close() {
        this.executorManager.close();
    }

    @Override
    public void submit(Runnable task) {
        this.executorManager.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorManager.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks) throws InterruptedException {
        return this.executorManager.invokeAll(tasks);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executorManager.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executorManager.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executorManager.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }
}

