/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.ParseException;
import org.compass.core.converter.basic.AbstractNumberConverter;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.NumberUtils;
import org.compass.core.mapping.ResourcePropertyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleConverter
extends AbstractNumberConverter<Double> {
    @Override
    protected Double defaultFromString(String str, ResourcePropertyMapping resourcePropertyMapping) {
        return Double.valueOf(str);
    }

    @Override
    protected Double fromNumber(Number number) {
        return number.doubleValue();
    }

    @Override
    protected Formatter createSortableFormatter() {
        return new Formatter(){

            public String format(Object obj) {
                double val = ((Number)obj).doubleValue();
                return NumberUtils.double2sortableStr(val);
            }

            public Object parse(String str) throws ParseException {
                return NumberUtils.SortableStr2double(str);
            }

            public boolean isThreadSafe() {
                return true;
            }
        };
    }
}

