/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.compass.core.config.CompassSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeCompassSettings
extends CompassSettings {
    private CompassSettings globalSettings;
    private CompassSettings runtimeSettings;

    public RuntimeCompassSettings(CompassSettings globalSettings) {
        this.globalSettings = globalSettings;
        this.runtimeSettings = new CompassSettings();
    }

    @Override
    public void addSettings(Properties settings) {
        this.runtimeSettings.addSettings(settings);
    }

    @Override
    public void addSettings(Map<String, Object> settings) {
        this.runtimeSettings.addSettings(settings);
    }

    @Override
    public void addSettings(CompassSettings settings) {
        this.runtimeSettings.addSettings(settings);
    }

    @Override
    public CompassSettings copy() {
        RuntimeCompassSettings copy = new RuntimeCompassSettings(this.globalSettings);
        copy.runtimeSettings = this.runtimeSettings.copy();
        return copy;
    }

    @Override
    public String getSetting(String setting) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return value;
        }
        return this.globalSettings.getSetting(setting);
    }

    @Override
    public Object getSettingAsObject(String setting) {
        Object value = this.runtimeSettings.getSettingAsObject(setting);
        if (value != null) {
            return value;
        }
        return this.globalSettings.getSettingAsObject(setting);
    }

    @Override
    public String getSetting(String setting, String defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return value;
        }
        return this.globalSettings.getSetting(setting, defaultValue);
    }

    @Override
    public Map<String, CompassSettings> getSettingGroups(String settingPrefix) {
        Map<String, CompassSettings> group = this.runtimeSettings.getSettingGroups(settingPrefix);
        if (group.size() != 0) {
            return group;
        }
        return this.globalSettings.getSettingGroups(settingPrefix);
    }

    @Override
    public float getSettingAsFloat(String setting, float defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsFloat(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsFloat(setting, defaultValue);
    }

    @Override
    public int getSettingAsInt(String setting, int defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsInt(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsInt(setting, defaultValue);
    }

    @Override
    public long getSettingAsLong(String setting, long defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsLong(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsLong(setting, defaultValue);
    }

    @Override
    public boolean getSettingAsBoolean(String setting, boolean defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsBoolean(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsBoolean(setting, defaultValue);
    }

    @Override
    public long getSettingAsTimeInSeconds(String setting, long defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsTimeInSeconds(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsTimeInSeconds(setting, defaultValue);
    }

    @Override
    public long getSettingAsTimeInMillis(String setting, long defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsTimeInMillis(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsTimeInMillis(setting, defaultValue);
    }

    @Override
    public long getSettingAsBytes(String setting, long defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsBytes(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsBytes(setting, defaultValue);
    }

    @Override
    public double getSettingAsDouble(String setting, double defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsDouble(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsDouble(setting, defaultValue);
    }

    @Override
    public Class getSettingAsClass(String setting, Class clazz) throws ClassNotFoundException {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsClass(setting, clazz);
        }
        return this.globalSettings.getSettingAsClass(setting, clazz);
    }

    @Override
    public Class getSettingAsClass(String setting, Class clazz, ClassLoader classLoader) throws ClassNotFoundException {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsClass(setting, clazz, classLoader);
        }
        return this.globalSettings.getSettingAsClass(setting, clazz, classLoader);
    }

    @Override
    public Object getSettingAsInstance(String setting, String defaultClass) {
        Object value = this.runtimeSettings.getSettingAsObject(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsInstance(setting, defaultClass);
        }
        return this.globalSettings.getSettingAsInstance(setting, defaultClass);
    }

    @Override
    public CompassSettings setSetting(String setting, String value) {
        this.runtimeSettings.setSetting(setting, value);
        return this;
    }

    @Override
    public CompassSettings setObjectSetting(String setting, Object value) {
        this.runtimeSettings.setObjectSetting(setting, value);
        return this;
    }

    @Override
    public CompassSettings setBooleanSetting(String setting, boolean value) {
        this.runtimeSettings.setBooleanSetting(setting, value);
        return this;
    }

    @Override
    public CompassSettings setFloatSetting(String setting, float value) {
        this.runtimeSettings.setFloatSetting(setting, value);
        return this;
    }

    @Override
    public CompassSettings setIntSetting(String setting, int value) {
        this.runtimeSettings.setIntSetting(setting, value);
        return this;
    }

    @Override
    public CompassSettings setLongSetting(String setting, long value) {
        this.runtimeSettings.setLongSetting(setting, value);
        return this;
    }

    @Override
    public CompassSettings setTimeSetting(String setting, long value, TimeUnit timeUnit) {
        this.runtimeSettings.setTimeSetting(setting, value, timeUnit);
        return this;
    }

    @Override
    public CompassSettings setDoubleSetting(String setting, double value) {
        this.runtimeSettings.setDoubleSetting(setting, value);
        return this;
    }

    @Override
    public CompassSettings setClassSetting(String setting, Class clazz) {
        this.runtimeSettings.setClassSetting(setting, clazz);
        return this;
    }

    @Override
    public CompassSettings setGroupSettings(String settingPrefix, String groupName, String[] settings, Object[] values) {
        this.runtimeSettings.setGroupSettings(settingPrefix, groupName, settings, values);
        return this;
    }

    @Override
    public Object getRegistry(Object key) {
        return this.globalSettings.getRegistry(key);
    }

    @Override
    public void setRegistry(Object key, Object value) {
        this.globalSettings.setRegistry(key, value);
    }

    @Override
    public Object removeRegistry(Object key) {
        return this.globalSettings.removeRegistry(key);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Global [").append(this.globalSettings).append("]");
        sb.append("Runtime [").append(this.runtimeSettings).append("]");
        return sb.toString();
    }
}

