/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.json;

import java.util.Iterator;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MultipleMapping;
import org.compass.core.mapping.json.JsonArrayMapping;
import org.compass.core.mapping.json.JsonContentMapping;
import org.compass.core.mapping.json.JsonMapping;
import org.compass.core.mapping.json.JsonPropertyMapping;
import org.compass.core.mapping.json.PlainJsonObjectMapping;
import org.compass.core.mapping.json.RootJsonObjectMapping;

public class JsonMappingIterator {
    public static void iterateMappings(JsonMappingCallback callback, RootJsonObjectMapping rootJsonObjectMapping, boolean recursive) {
        if (!callback.onBeginMultipleMapping(rootJsonObjectMapping)) {
            return;
        }
        callback.onJsonRootObject(rootJsonObjectMapping);
        JsonMappingIterator.iterateMappings(callback, (MultipleMapping)rootJsonObjectMapping, recursive);
        callback.onEndMultipleMapping(rootJsonObjectMapping);
    }

    private static void iterateMappings(JsonMappingCallback callback, MultipleMapping mapping, boolean recursive) {
        Iterator<Mapping> mappingsIt = mapping.mappingsIt();
        while (mappingsIt.hasNext()) {
            Mapping m = mappingsIt.next();
            JsonMappingIterator.iterateMapping(callback, m, recursive);
        }
    }

    private static void iterateMapping(JsonMappingCallback callback, Mapping mapping, boolean recursive) {
        if (mapping instanceof JsonPropertyMapping) {
            callback.onJsonProperty((JsonPropertyMapping)mapping);
        } else if (mapping instanceof JsonContentMapping) {
            callback.onJsonContent((JsonContentMapping)mapping);
        } else if (mapping instanceof PlainJsonObjectMapping) {
            PlainJsonObjectMapping jsonObjectMapping = (PlainJsonObjectMapping)mapping;
            if (!callback.onBeginMultipleMapping(jsonObjectMapping)) {
                return;
            }
            callback.onJsonObject(jsonObjectMapping);
            if (recursive) {
                JsonMappingIterator.iterateMappings(callback, jsonObjectMapping, recursive);
            }
            callback.onEndMultipleMapping(jsonObjectMapping);
        } else if (mapping instanceof JsonArrayMapping) {
            JsonArrayMapping jsonArrayMapping = (JsonArrayMapping)mapping;
            callback.onJsonArray(jsonArrayMapping);
            JsonMappingIterator.iterateMapping(callback, jsonArrayMapping.getElementMapping(), recursive);
        }
    }

    public static interface JsonMappingCallback {
        public void onJsonRootObject(RootJsonObjectMapping var1);

        public void onJsonObject(PlainJsonObjectMapping var1);

        public void onJsonContent(JsonContentMapping var1);

        public void onJsonProperty(JsonPropertyMapping var1);

        public void onJsonArray(JsonArrayMapping var1);

        public boolean onBeginMultipleMapping(JsonMapping var1);

        public void onEndMultipleMapping(JsonMapping var1);
    }
}

