/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.ResourceFactory;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.engine.SearchEngineIndexManager;
import org.compass.core.engine.SearchEngineOptimizer;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.engine.spellcheck.SearchEngineSpellCheckManager;
import org.compass.core.events.CompassEventManager;
import org.compass.core.events.RebuildEventListener;
import org.compass.core.executor.ExecutorManager;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.spi.InternalCompass;
import org.compass.core.transaction.LocalTransactionFactory;
import org.compass.core.transaction.TransactionFactory;

public class RefreshableCompass
implements InternalCompass {
    private static final Log logger = LogFactory.getLog(RefreshableCompass.class);
    private final CompassConfiguration config;
    private volatile InternalCompass compass;
    private List<RebuildEventListener> rebuildEventListeners = new ArrayList<RebuildEventListener>();

    public RefreshableCompass(CompassConfiguration config, InternalCompass compass) {
        this.config = config;
        this.compass = compass;
    }

    public CompassConfiguration getConfig() {
        return this.config;
    }

    public synchronized void rebuild() throws CompassException {
        InternalCompass rebuiltCompass;
        this.compass.stop();
        this.config.getSettings().addSettings(this.compass.getSettings());
        try {
            rebuiltCompass = (InternalCompass)this.config.buildCompass();
        }
        catch (RuntimeException e) {
            this.compass.start();
            throw e;
        }
        Thread t = new Thread((Runnable)new CloseCompassRunnable(this.compass), "Close Compass");
        t.start();
        this.compass = rebuiltCompass;
        for (RebuildEventListener eventListener : this.rebuildEventListeners) {
            eventListener.onCompassRebuild(this.compass);
        }
    }

    public Compass clone(CompassSettings addedSettings) {
        InternalCompass clonedCompass = (InternalCompass)this.compass.clone(addedSettings);
        return new RefreshableCompass(this.config, clonedCompass);
    }

    public synchronized void addRebuildEventListener(RebuildEventListener eventListener) {
        this.rebuildEventListeners.add(eventListener);
    }

    public synchronized void removeRebuildEventListener(RebuildEventListener eventListener) {
        this.rebuildEventListeners.remove(eventListener);
    }

    public void start() {
        this.compass.start();
    }

    public void stop() {
        this.compass.stop();
    }

    public CompassSession openSession(boolean allowCreate, boolean checkClosed) {
        return this.compass.openSession(allowCreate, checkClosed);
    }

    public CompassSession openSession() throws CompassException {
        return this.compass.openSession();
    }

    public String getName() {
        return this.compass.getName();
    }

    public CompassSettings getSettings() {
        return this.compass.getSettings();
    }

    public CompassMapping getMapping() {
        return this.compass.getMapping();
    }

    public ExecutorManager getExecutorManager() {
        return this.compass.getExecutorManager();
    }

    public CompassMetaData getMetaData() {
        return this.compass.getMetaData();
    }

    public SearchEngineFactory getSearchEngineFactory() {
        return this.compass.getSearchEngineFactory();
    }

    public TransactionFactory getTransactionFactory() {
        return this.compass.getTransactionFactory();
    }

    public LocalTransactionFactory getLocalTransactionFactory() {
        return this.compass.getLocalTransactionFactory();
    }

    public ConverterLookup getConverterLookup() {
        return this.compass.getConverterLookup();
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.compass.getPropertyNamingStrategy();
    }

    public CompassEventManager getEventManager() {
        return this.compass.getEventManager();
    }

    public void close() throws CompassException {
        this.compass.close();
    }

    public ResourceFactory getResourceFactory() {
        return this.compass.getResourceFactory();
    }

    public SearchEngineOptimizer getSearchEngineOptimizer() {
        return this.compass.getSearchEngineOptimizer();
    }

    public SearchEngineIndexManager getSearchEngineIndexManager() {
        return this.compass.getSearchEngineIndexManager();
    }

    public SearchEngineSpellCheckManager getSpellCheckManager() {
        return this.compass.getSpellCheckManager();
    }

    public boolean isClosed() {
        return this.compass.isClosed();
    }

    public Reference getReference() throws NamingException {
        return this.compass.getReference();
    }

    private class CloseCompassRunnable
    implements Runnable {
        private Compass compass;

        private CloseCompassRunnable(Compass compass) {
            this.compass = compass;
        }

        public void run() {
            try {
                Thread.sleep(RefreshableCompass.this.getConfig().getSettings().getSettingAsLong("compass.rebuild.sleepBeforeClose", 60000L));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.compass.close();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close original Compass after rebuild", (Throwable)e);
            }
        }
    }
}

