/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.util.Locale;
import org.compass.core.CompassException;
import org.compass.core.Property;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.basic.AbstractBasicConverter;
import org.compass.core.converter.basic.FormatConverter;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.FormatterFactory;
import org.compass.core.converter.basic.format.ThreadSafeFormat;
import org.compass.core.util.StringUtils;

public abstract class AbstractFormatConverter
extends AbstractBasicConverter
implements CompassConfigurable,
FormatConverter {
    protected Formatter[] formatters;
    protected boolean hasFormatter = true;
    protected Locale locale;

    public void configure(CompassSettings settings) throws CompassException {
        String localeSetting;
        String format = settings.getSetting("format");
        if (format == null) {
            format = this.doGetDefaultFormat();
        }
        this.locale = (localeSetting = settings.getSetting("format.locale")) != null ? new Locale(localeSetting) : Locale.getDefault();
        if (format == null) {
            this.hasFormatter = false;
            return;
        }
        this.createFormatters(format, settings);
    }

    public void setFormat(String format) {
        this.createFormatters(format, null);
    }

    public FormatConverter copy() {
        try {
            AbstractFormatConverter copy = (AbstractFormatConverter)this.getClass().newInstance();
            copy.locale = this.locale;
            return copy;
        }
        catch (Exception e) {
            throw new CompassException("Should not happen", e);
        }
    }

    protected abstract FormatterFactory doCreateFormatterFactory();

    protected String doGetDefaultFormat() {
        return null;
    }

    private void createFormatters(String format, CompassSettings settings) {
        String[] formatStrings = StringUtils.delimitedListToStringArray(format, "||");
        this.formatters = new Formatter[formatStrings.length];
        for (int i = 0; i < this.formatters.length; ++i) {
            String currentFromat = formatStrings[i];
            FormatterFactory formatterFactory = this.doCreateFormatterFactory();
            formatterFactory.configure(currentFromat, this.locale);
            this.formatters[i] = formatterFactory.create();
            if (this.formatters[i].isThreadSafe()) continue;
            int minPoolSize = 4;
            int maxPoolSize = 20;
            if (settings != null) {
                minPoolSize = settings.getSettingAsInt("format.minPoolSize", minPoolSize);
                maxPoolSize = settings.getSettingAsInt("format.maxPoolSize", maxPoolSize);
            }
            this.formatters[i] = new ThreadSafeFormat(minPoolSize, maxPoolSize, formatterFactory);
        }
    }

    public boolean canNormalize() {
        return true;
    }

    public Property.Index suggestIndex() {
        return Property.Index.NOT_ANALYZED;
    }
}

