/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public abstract class AbstractBasicConverter
implements ResourcePropertyConverter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        if (root == null && !this.handleNulls(resourcePropertyMapping, context)) {
            return false;
        }
        String sValue = this.toString(root, resourcePropertyMapping, context);
        Property p = this.createProperty(sValue, resourcePropertyMapping, context);
        this.doSetBoost(p, root, resourcePropertyMapping, context);
        resource.addProperty(p);
        return resourcePropertyMapping.getStore() != Property.Store.NO;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        ResourcePropertyMapping resourcePropertyMapping = (ResourcePropertyMapping)mapping;
        if (resourcePropertyMapping.getStore() == Property.Store.NO) {
            return null;
        }
        String propertyName = resourcePropertyMapping.getPath().getPath();
        Property p = resource.getProperty(propertyName);
        if (p == null) {
            return null;
        }
        return this.fromString(p.getStringValue(), resourcePropertyMapping, context);
    }

    protected Property createProperty(String value, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return context.getResourceFactory().createProperty(value, resourcePropertyMapping);
    }

    protected boolean handleNulls(ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return resourcePropertyMapping.hasNullValue() || context.handleNulls();
    }

    protected String getNullValue(ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return resourcePropertyMapping.getNullValue();
    }

    protected boolean isNullValue(String value, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        if (value == null) {
            return true;
        }
        if (resourcePropertyMapping.hasNullValue()) {
            return resourcePropertyMapping.getNullValue().equals(value);
        }
        return value.length() == 0;
    }

    protected void doSetBoost(Property property, Object root, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        property.setBoost(resourcePropertyMapping.getBoost());
    }

    public String toString(Object o, ResourcePropertyMapping resourcePropertyMapping) {
        return this.toString(o, resourcePropertyMapping, null);
    }

    protected String toString(Object o, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        String sValue = o != null ? this.doToString(o, resourcePropertyMapping, context) : this.getNullValue(resourcePropertyMapping, context);
        return sValue;
    }

    protected String doToString(Object o, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return o.toString();
    }

    public Object fromString(String str, ResourcePropertyMapping resourcePropertyMapping) throws ConversionException {
        return this.fromString(str, resourcePropertyMapping, null);
    }

    protected Object fromString(String str, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        if (this.isNullValue(str, resourcePropertyMapping, context)) {
            return null;
        }
        return this.doFromString(str, resourcePropertyMapping, context);
    }

    protected abstract Object doFromString(String var1, ResourcePropertyMapping var2, MarshallingContext var3) throws ConversionException;

    public boolean canNormalize() {
        return false;
    }

    public Property.Index suggestIndex() {
        return null;
    }

    public Property.TermVector suggestTermVector() {
        return null;
    }

    public Property.Store suggestStore() {
        return null;
    }

    public Boolean suggestOmitNorms() {
        return null;
    }

    public Boolean suggestOmitTf() {
        return null;
    }
}

