/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.jdom.converter;

import java.io.Reader;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.xsem.SupportsXmlContentWrapper;
import org.compass.core.xml.AliasedXmlObject;
import org.compass.core.xml.jdom.JDomAliasedXmlObject;
import org.compass.core.xml.jdom.converter.AbstractXmlOutputterXmlContentConverter;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class SAXBuilderXmlContentConverter
extends AbstractXmlOutputterXmlContentConverter
implements SupportsXmlContentWrapper,
CompassConfigurable {
    private SAXBuilder saxBuilder;

    public void configure(CompassSettings settings) throws CompassException {
        this.saxBuilder = this.doCreateSAXBuilder(settings);
    }

    protected SAXBuilder doCreateSAXBuilder(CompassSettings settings) {
        return new SAXBuilder();
    }

    public boolean supports(String wrapper) {
        return !"singleton".equals(wrapper);
    }

    public AliasedXmlObject fromXml(String alias, Reader xml) throws ConversionException {
        Document doc;
        try {
            doc = this.saxBuilder.build(xml);
        }
        catch (Exception e) {
            throw new ConversionException("Failed to parse alias[" + alias + "] xml[" + xml + "]", e);
        }
        return new JDomAliasedXmlObject(alias, doc.getRootElement());
    }
}

