/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.DynamicMetaDataMapping;
import org.compass.core.mapping.osem.ObjectMapping;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.PlainCascadeMapping;
import org.compass.core.mapping.osem.RefAliasObjectMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.util.Assert;

public abstract class OsemMappingIterator {
    public static void iterateMappings(ClassMappingCallback callback, ClassMapping classMapping) {
        OsemMappingIterator.iterateMappings(callback, classMapping, true);
    }

    public static void iterateMappings(ClassMappingCallback callback, ClassMapping classMapping, boolean recursive) {
        if (!callback.onBeginClassMapping(classMapping)) {
            return;
        }
        Iterator<Mapping> mappingsIt = classMapping.mappingsIt();
        while (mappingsIt.hasNext()) {
            Mapping m = mappingsIt.next();
            if (m instanceof ClassPropertyMapping) {
                ClassPropertyMapping classPropertyMapping = (ClassPropertyMapping)m;
                OsemMappingIterator.iteratePropertyMapping(callback, classMapping, classPropertyMapping);
                continue;
            }
            if (m instanceof ParentMapping) {
                callback.onParentMapping(classMapping, (ParentMapping)m);
                continue;
            }
            if (m instanceof PlainCascadeMapping) {
                callback.onCascadeMapping(classMapping, (PlainCascadeMapping)m);
                continue;
            }
            if (m instanceof DynamicMetaDataMapping) {
                DynamicMetaDataMapping dynamicMetaDataMapping = (DynamicMetaDataMapping)m;
                callback.onDynamicMetaDataMapping(classMapping, dynamicMetaDataMapping);
                callback.onResourcePropertyMapping(dynamicMetaDataMapping);
                continue;
            }
            if (m instanceof ComponentMapping) {
                ComponentMapping componentMapping = (ComponentMapping)m;
                OsemMappingIterator.iterateComponentMapping(callback, classMapping, componentMapping, recursive);
                continue;
            }
            if (m instanceof ReferenceMapping) {
                ReferenceMapping referenceMapping = (ReferenceMapping)m;
                OsemMappingIterator.iterateReferenceMapping(callback, classMapping, referenceMapping, recursive);
                continue;
            }
            if (m instanceof ConstantMetaDataMapping) {
                ConstantMetaDataMapping constantMetaDataMapping = (ConstantMetaDataMapping)m;
                boolean drillDown = callback.onBeginMultipleMapping(classMapping, constantMetaDataMapping);
                if (drillDown) {
                    callback.onConstantMetaDataMappaing(classMapping, constantMetaDataMapping);
                    callback.onResourcePropertyMapping(constantMetaDataMapping);
                }
                callback.onEndMultiplMapping(classMapping, constantMetaDataMapping);
                continue;
            }
            if (!(m instanceof AbstractCollectionMapping)) continue;
            AbstractCollectionMapping colMapping = (AbstractCollectionMapping)m;
            callback.onBeginCollectionMapping(colMapping);
            Mapping elementMapping = colMapping.getElementMapping();
            if (elementMapping instanceof ClassPropertyMapping) {
                ClassPropertyMapping classPropertyMapping = (ClassPropertyMapping)elementMapping;
                OsemMappingIterator.iteratePropertyMapping(callback, classMapping, classPropertyMapping);
            } else if (elementMapping instanceof ComponentMapping) {
                ComponentMapping componentMapping = (ComponentMapping)elementMapping;
                OsemMappingIterator.iterateComponentMapping(callback, classMapping, componentMapping, recursive);
            } else if (elementMapping instanceof ReferenceMapping) {
                ReferenceMapping referenceMapping = (ReferenceMapping)elementMapping;
                OsemMappingIterator.iterateReferenceMapping(callback, classMapping, referenceMapping, recursive);
            } else if (elementMapping instanceof PlainCascadeMapping) {
                callback.onCascadeMapping(classMapping, (PlainCascadeMapping)elementMapping);
            }
            callback.onEndCollectionMapping(colMapping);
        }
        callback.onEndClassMapping(classMapping);
    }

    private static void iterateReferenceMapping(ClassMappingCallback callback, ClassMapping classMapping, ReferenceMapping referenceMapping, boolean recursive) {
        boolean drillDown = callback.onBeginMultipleMapping(classMapping, referenceMapping);
        if (drillDown) {
            callback.onReferenceMapping(classMapping, referenceMapping);
            if (recursive) {
                ClassMapping[] refMappings;
                for (ClassMapping refMapping : refMappings = referenceMapping.getRefClassMappings()) {
                    OsemMappingIterator.iterateMappings(callback, refMapping);
                }
                if (referenceMapping.getRefCompMapping() != null) {
                    OsemMappingIterator.iterateMappings(callback, referenceMapping.getRefCompMapping());
                }
            }
        }
        callback.onEndMultiplMapping(classMapping, referenceMapping);
    }

    private static void iterateComponentMapping(ClassMappingCallback callback, ClassMapping classMapping, ComponentMapping componentMapping, boolean recursive) {
        boolean drillDown = callback.onBeginMultipleMapping(classMapping, componentMapping);
        if (drillDown) {
            callback.onComponentMapping(classMapping, componentMapping);
            if (recursive) {
                ClassMapping[] refMappings;
                for (ClassMapping refMapping : refMappings = componentMapping.getRefClassMappings()) {
                    OsemMappingIterator.iterateMappings(callback, refMapping);
                }
            }
        }
        callback.onEndMultiplMapping(classMapping, componentMapping);
    }

    private static void iteratePropertyMapping(ClassMappingCallback callback, ClassMapping classMapping, ClassPropertyMapping classPropertyMapping) {
        boolean drillDown = callback.onBeginMultipleMapping(classMapping, classPropertyMapping);
        if (drillDown) {
            callback.onClassPropertyMapping(classMapping, classPropertyMapping);
            Iterator<Mapping> resIt = classPropertyMapping.mappingsIt();
            while (resIt.hasNext()) {
                ClassPropertyMetaDataMapping classPropertyMetaDataMapping = (ClassPropertyMetaDataMapping)resIt.next();
                callback.onClassPropertyMetaDataMapping(classPropertyMetaDataMapping);
                callback.onResourcePropertyMapping(classPropertyMetaDataMapping);
            }
        }
        callback.onEndMultiplMapping(classMapping, classPropertyMapping);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassPropertyAndResourcePropertyGatherer
    implements ClassMappingCallback {
        private ArrayList<ClassPropertyMapping> classPropertyMappings = new ArrayList();
        private ArrayList<ResourcePropertyMapping> resourcePropertyMappings = new ArrayList();
        private HashMap<Integer, HashMap<Object, HashMap<Object, ObjectMapping>>> ignoreInheritedDuplicatesClassMappings = new HashMap();

        public List<ClassPropertyMapping> getClassPropertyMappings() {
            return this.classPropertyMappings;
        }

        public List<ResourcePropertyMapping> getResourcePropertyMappings() {
            return this.resourcePropertyMappings;
        }

        @Override
        public boolean onBeginClassMapping(ClassMapping classMapping) {
            return true;
        }

        @Override
        public void onEndClassMapping(ClassMapping classMapping) {
        }

        @Override
        public boolean onBeginMultipleMapping(ClassMapping classMapping, Mapping mapping) {
            HashMap<Object, HashMap<Object, ObjectMapping>> byAlias;
            ClassMapping[] classMappings;
            if (mapping instanceof RefAliasObjectMapping && (classMappings = ((RefAliasObjectMapping)mapping).getRefClassMappings()).length > 1) {
                HashMap byAlias2 = new HashMap();
                for (ClassMapping classMapping1 : classMappings) {
                    this.ignoreInheritedDuplicatesClassMappings.put(System.identityHashCode(classMapping1), byAlias2);
                }
            }
            if ((byAlias = this.ignoreInheritedDuplicatesClassMappings.get(new Integer(System.identityHashCode(classMapping)))) != null && mapping instanceof ObjectMapping) {
                ObjectMapping actualObjectMapping;
                ObjectMapping objectMapping = (ObjectMapping)mapping;
                Assert.notNull(objectMapping.getDefinedInAlias(), "Internal Compass Error, Defined in Alias not found for [" + objectMapping.getPropertyName() + "] in alias [" + classMapping.getAlias() + "]");
                HashMap<Object, ObjectMapping> propByAlias = byAlias.get(objectMapping.getDefinedInAlias());
                if (propByAlias == null) {
                    propByAlias = new HashMap();
                    byAlias.put(objectMapping.getDefinedInAlias(), propByAlias);
                }
                if ((actualObjectMapping = propByAlias.get(objectMapping.getPropertyName())) != null) {
                    this.onDuplicateMapping(classMapping, actualObjectMapping, objectMapping);
                    return false;
                }
                propByAlias.put(objectMapping.getPropertyName(), objectMapping);
            }
            return true;
        }

        protected void onDuplicateMapping(ClassMapping classMapping, ObjectMapping actualMapping, ObjectMapping duplicateMapping) {
        }

        @Override
        public void onEndMultiplMapping(ClassMapping classMapping, Mapping mapping) {
        }

        @Override
        public void onBeginCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        @Override
        public void onEndCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        @Override
        public void onClassPropertyMapping(ClassMapping classMapping, ClassPropertyMapping classPropertyMapping) {
            this.classPropertyMappings.add(classPropertyMapping);
        }

        @Override
        public void onParentMapping(ClassMapping classMapping, ParentMapping parentMapping) {
        }

        @Override
        public void onCascadeMapping(ClassMapping classMapping, PlainCascadeMapping cascadeMapping) {
        }

        @Override
        public void onComponentMapping(ClassMapping classMapping, ComponentMapping componentMapping) {
        }

        @Override
        public void onReferenceMapping(ClassMapping classMapping, ReferenceMapping referenceMapping) {
        }

        @Override
        public void onConstantMetaDataMappaing(ClassMapping classMapping, ConstantMetaDataMapping constantMetaDataMapping) {
        }

        @Override
        public void onClassPropertyMetaDataMapping(ClassPropertyMetaDataMapping classPropertyMetaDataMapping) {
        }

        @Override
        public void onDynamicMetaDataMapping(ClassMapping classMapping, DynamicMetaDataMapping dynamicMetaDataMapping) {
        }

        @Override
        public void onResourcePropertyMapping(ResourcePropertyMapping resourcePropertyMapping) {
            this.resourcePropertyMappings.add(resourcePropertyMapping);
        }
    }

    public static interface ClassMappingCallback {
        public boolean onBeginClassMapping(ClassMapping var1);

        public void onEndClassMapping(ClassMapping var1);

        public boolean onBeginMultipleMapping(ClassMapping var1, Mapping var2);

        public void onEndMultiplMapping(ClassMapping var1, Mapping var2);

        public void onBeginCollectionMapping(AbstractCollectionMapping var1);

        public void onEndCollectionMapping(AbstractCollectionMapping var1);

        public void onClassPropertyMapping(ClassMapping var1, ClassPropertyMapping var2);

        public void onComponentMapping(ClassMapping var1, ComponentMapping var2);

        public void onReferenceMapping(ClassMapping var1, ReferenceMapping var2);

        public void onCascadeMapping(ClassMapping var1, PlainCascadeMapping var2);

        public void onParentMapping(ClassMapping var1, ParentMapping var2);

        public void onConstantMetaDataMappaing(ClassMapping var1, ConstantMetaDataMapping var2);

        public void onClassPropertyMetaDataMapping(ClassPropertyMetaDataMapping var1);

        public void onDynamicMetaDataMapping(ClassMapping var1, DynamicMetaDataMapping var2);

        public void onResourcePropertyMapping(ResourcePropertyMapping var1);
    }
}

