/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene;

import org.apache.lucene.document.Field;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.engine.RepeatableReader;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.spi.InternalProperty;

public class LuceneProperty
implements InternalProperty {
    private static final long serialVersionUID = 3690475809949104182L;
    private Field field;
    private RepeatableReader reader;
    private transient ResourcePropertyMapping propertyMapping;

    public LuceneProperty(Field field) {
        this.field = field;
    }

    public LuceneProperty(Field field, RepeatableReader reader) {
        this.field = field;
        this.reader = reader;
    }

    public void setPropertyMapping(ResourcePropertyMapping propertyMapping) {
        this.propertyMapping = propertyMapping;
    }

    public ResourcePropertyMapping getPropertyMapping() {
        return this.propertyMapping;
    }

    public RepeatableReader getRepeatableReader() {
        return this.reader;
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.field.name();
    }

    public Object getObjectValue() {
        String value = this.getStringValue();
        if (this.propertyMapping == null) {
            return value;
        }
        ResourcePropertyConverter converter = this.propertyMapping.getResourcePropertyConverter();
        if (converter == null) {
            return null;
        }
        return converter.fromString(value, this.propertyMapping);
    }

    public String getStringValue() {
        return this.field.stringValue();
    }

    public byte[] getBinaryValue() {
        return this.field.binaryValue();
    }

    public float getBoost() {
        return this.field.getBoost();
    }

    public void setBoost(float boost) {
        this.field.setBoost(boost);
    }

    public boolean isIndexed() {
        return this.field.isIndexed();
    }

    public boolean isStored() {
        return this.field.isStored();
    }

    public boolean isCompressed() {
        return this.field.isCompressed();
    }

    public boolean isBinary() {
        return this.field.isBinary();
    }

    public boolean isTokenized() {
        return this.field.isTokenized();
    }

    public boolean isTermVectorStored() {
        return this.field.isTermVectorStored();
    }

    public boolean isStoreOffsetWithTermVector() {
        return this.field.isStoreOffsetWithTermVector();
    }

    public boolean isStorePositionWithTermVector() {
        return this.field.isStorePositionWithTermVector();
    }

    public boolean isOmitNorms() {
        return this.field.getOmitNorms();
    }

    public void setOmitNorms(boolean omitNorms) {
        this.field.setOmitNorms(omitNorms);
    }

    public boolean isOmitTf() {
        return this.field.getOmitTf();
    }

    public void setOmitTf(boolean omitTf) {
        this.field.setOmitTf(omitTf);
    }

    public String toString() {
        return "[" + this.field + "]";
    }
}

