/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.testutil.example;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.commonmark.testutil.example.Example;

public class ExampleReader {
    private static final Pattern SECTION_PATTERN = Pattern.compile("#{1,6} *(.*)");
    private static final String EXAMPLE_START_MARKER = "```````````````````````````````` example";
    private final InputStream inputStream;
    private final String filename;
    private State state = State.BEFORE;
    private String section;
    private String info = "";
    private StringBuilder source;
    private StringBuilder html;
    private int exampleNumber = 0;
    private List<Example> examples = new ArrayList<Example>();

    private ExampleReader(InputStream stream, String filename) {
        this.inputStream = stream;
        this.filename = filename;
    }

    public static List<Example> readExamples(URL url) {
        List<Example> list;
        block8: {
            InputStream stream = url.openStream();
            try {
                list = new ExampleReader(stream, new File(url.getPath()).getName()).read();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return list;
    }

    public static List<Example> readExamples(URL url, String info) {
        List<Example> examples = ExampleReader.readExamples(url);
        return examples.stream().filter(e -> e.getInfo().contains(info)).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    public static List<Object[]> readExampleObjects(URL url, String info) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> readExampleSources(URL url) {
        List<Example> examples = ExampleReader.readExamples(url);
        ArrayList<String> result = new ArrayList<String>();
        for (Example example : examples) {
            result.add(example.getSource());
        }
        return result;
    }

    private List<Example> read() throws IOException {
        this.resetContents();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.processLine(line);
            }
        }
        return this.examples;
    }

    private void processLine(String line) {
        switch (this.state.ordinal()) {
            case 0: {
                Matcher matcher = SECTION_PATTERN.matcher(line);
                if (matcher.matches()) {
                    this.section = matcher.group(1);
                    this.exampleNumber = 0;
                }
                if (!line.startsWith(EXAMPLE_START_MARKER)) break;
                this.info = line.substring(EXAMPLE_START_MARKER.length()).trim();
                this.state = State.SOURCE;
                ++this.exampleNumber;
                break;
            }
            case 1: {
                if (line.equals(".")) {
                    this.state = State.HTML;
                    break;
                }
                String processedLine = line.replace('\u2192', '\t');
                this.source.append(processedLine).append('\n');
                break;
            }
            case 2: {
                if (line.equals("````````````````````````````````")) {
                    this.state = State.BEFORE;
                    this.examples.add(new Example(this.filename, this.section, this.info, this.exampleNumber, this.source.toString(), this.html.toString()));
                    this.resetContents();
                    break;
                }
                this.html.append(line).append('\n');
            }
        }
    }

    private void resetContents() {
        this.source = new StringBuilder();
        this.html = new StringBuilder();
    }

    private static enum State {
        BEFORE,
        SOURCE,
        HTML;

    }
}

