/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.image.attributes.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.commonmark.ext.image.attributes.ImageAttributes;
import org.commonmark.node.Image;
import org.commonmark.node.Node;
import org.commonmark.node.Nodes;
import org.commonmark.node.Text;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;

public class ImageAttributesDelimiterProcessor
implements DelimiterProcessor {
    private static final Set<String> SUPPORTED_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("width", "height")));

    public char getOpeningCharacter() {
        return '{';
    }

    public char getClosingCharacter() {
        return '}';
    }

    public int getMinLength() {
        return 1;
    }

    public int process(DelimiterRun openingRun, DelimiterRun closingRun) {
        if (openingRun.length() != 1) {
            return 0;
        }
        Text opener = openingRun.getOpener();
        Node nodeToStyle = opener.getPrevious();
        if (!(nodeToStyle instanceof Image)) {
            return 0;
        }
        ArrayList<Node> toUnlink = new ArrayList<Node>();
        StringBuilder content = new StringBuilder();
        for (Node node : Nodes.between((Node)opener, (Node)closingRun.getCloser())) {
            if (node instanceof Text) {
                content.append(((Text)node).getLiteral());
                toUnlink.add(node);
                continue;
            }
            return 0;
        }
        LinkedHashMap<String, String> attributesMap = new LinkedHashMap<String, String>();
        String attributes = content.toString();
        for (String s : attributes.split("\\s+")) {
            String[] attribute = s.split("=");
            if (attribute.length <= 1 || !SUPPORTED_ATTRIBUTES.contains(attribute[0].toLowerCase())) {
                return 0;
            }
            attributesMap.put(attribute[0], attribute[1]);
        }
        for (Node node : toUnlink) {
            node.unlink();
        }
        if (attributesMap.size() > 0) {
            ImageAttributes imageAttributes = new ImageAttributes(attributesMap);
            nodeToStyle.appendChild((Node)imageAttributes);
        }
        return 1;
    }
}

