/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.footnotes.internal;

import java.util.List;
import org.commonmark.ext.footnotes.FootnoteDefinition;
import org.commonmark.node.Block;
import org.commonmark.node.DefinitionMap;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockParserFactory;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import org.commonmark.text.Characters;

public class FootnoteBlockParser
extends AbstractBlockParser {
    private final FootnoteDefinition block;

    public FootnoteBlockParser(String label) {
        this.block = new FootnoteDefinition(label);
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(Block childBlock) {
        return true;
    }

    public BlockContinue tryContinue(ParserState parserState) {
        if (parserState.getIndent() >= 4) {
            return BlockContinue.atColumn((int)4);
        }
        if (parserState.isBlank()) {
            return BlockContinue.atIndex((int)parserState.getIndex());
        }
        return BlockContinue.none();
    }

    public List<DefinitionMap<?>> getDefinitions() {
        DefinitionMap map = new DefinitionMap(FootnoteDefinition.class);
        map.putIfAbsent(this.block.getLabel(), (Object)this.block);
        return List.of(map);
    }

    public static class Factory
    implements BlockParserFactory {
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int labelStart;
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            int index = state.getNextNonSpaceIndex();
            CharSequence content = state.getLine().getContent();
            if (content.charAt(index) != '[' || index + 1 >= content.length()) {
                return BlockStart.none();
            }
            if (content.charAt(++index) != '^' || index + 1 >= content.length()) {
                return BlockStart.none();
            }
            ++index;
            for (index = labelStart = index; index < content.length(); ++index) {
                char c = content.charAt(index);
                switch (c) {
                    case ']': {
                        if (index > labelStart && index + 1 < content.length() && content.charAt(index + 1) == ':') {
                            String label = content.subSequence(labelStart, index).toString();
                            int afterSpaces = Characters.skipSpaceTab((CharSequence)content, (int)(index + 2), (int)content.length());
                            return BlockStart.of((BlockParser[])new BlockParser[]{new FootnoteBlockParser(label)}).atIndex(afterSpaces);
                        }
                        return BlockStart.none();
                    }
                    case '\u0000': 
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        return BlockStart.none();
                    }
                }
            }
            return BlockStart.none();
        }
    }
}

