/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.web.json.ser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.commonjava.web.json.model.Listing;
import org.commonjava.web.json.ser.DeserializerPostProcessor;
import org.commonjava.web.json.ser.JsonAdapters;
import org.commonjava.web.json.ser.ListingAdapter;
import org.commonjava.web.json.ser.WebSerializationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Alternative
@Named(value="base")
public class JsonSerializer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final WebSerializationAdapter[] DEFAULT_ADAPTERS = new WebSerializationAdapter[]{new ListingAdapter()};
    private final Set<WebSerializationAdapter> baseAdapters = new HashSet<WebSerializationAdapter>();
    @Inject
    @Any
    Instance<WebSerializationAdapter> adapterInstance;

    JsonSerializer() {
    }

    public JsonSerializer(WebSerializationAdapter ... baseAdapters) {
        this.baseAdapters.addAll(Arrays.asList(baseAdapters));
    }

    public void registerSerializationAdapters(WebSerializationAdapter ... adapters) {
        this.baseAdapters.addAll(Arrays.asList(adapters));
    }

    private Gson getGson(Type type) {
        GsonBuilder builder = new GsonBuilder();
        if (type != null) {
            this.registerAnnotationAdapters(type, builder, new HashSet<Type>());
        }
        if (this.adapterInstance != null) {
            for (WebSerializationAdapter adapter : this.adapterInstance) {
                adapter.register(builder);
            }
        }
        if (this.baseAdapters != null) {
            for (WebSerializationAdapter adapter : this.baseAdapters) {
                adapter.register(builder);
            }
        }
        for (WebSerializationAdapter adapter : DEFAULT_ADAPTERS) {
            adapter.register(builder);
        }
        return builder.create();
    }

    private void registerAnnotationAdapters(Type type, GsonBuilder builder, Set<Type> seen) {
        if (seen.contains(type)) {
            return;
        }
        seen.add(type);
        if (type instanceof Class) {
            Field[] fields;
            Class typeCls = (Class)type;
            JsonAdapters adapters = typeCls.getAnnotation(JsonAdapters.class);
            if (adapters != null) {
                for (Class<? extends WebSerializationAdapter> adapterCls : adapters.value()) {
                    try {
                        this.logger.debug("[REGISTER] JSON adapter from annotation: {}", (Object)adapterCls.getName());
                        adapterCls.newInstance().register(builder);
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException("Cannot instantiate adapter from JsonAdapters annotation: " + adapterCls.getName());
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Cannot instantiate adapter from JsonAdapters annotation: " + adapterCls.getName());
                    }
                }
            }
            for (Field field : fields = typeCls.getDeclaredFields()) {
                Class<?> fieldType = field.getType();
                this.registerAnnotationAdapters(fieldType, builder, seen);
            }
        }
    }

    public String toString(Object src) {
        return this.getGson(src.getClass()).toJson(src);
    }

    public String toString(Object src, Type type) {
        return this.getGson(src.getClass()).toJson(src, type);
    }

    public <T> T fromString(String src, Type type) {
        Object result = this.getGson(type).fromJson(src, type);
        return (T)result;
    }

    public <T> T fromString(String src, TypeToken<T> token) {
        Object result = this.getGson(token.getType()).fromJson(src, token.getType());
        return (T)result;
    }

    public <T> T fromStream(InputStream stream, String encoding, Class<T> type) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            InputStreamReader reader = new InputStreamReader(stream, encoding);
            String json = IOUtils.toString((Reader)reader);
            this.logger.debug("JSON:\n\n{}\n\n", (Object)json);
            Object result = this.getGson(type).fromJson(json, type);
            result = this.postProcess(result);
            return (T)result;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Failed to deserialize type: {}. Error: {}", new Object[]{e, type.getName(), e.getMessage()});
            throw new RuntimeException("Cannot read stream.");
        }
        catch (IOException e) {
            this.logger.error("Failed to deserialize type: {}. Error: {}", new Object[]{e, type.getName(), e.getMessage()});
            throw new RuntimeException("Cannot read stream.");
        }
    }

    private <T> T postProcess(T input) {
        return input;
    }

    public <T> T fromStream(InputStream stream, String encoding, TypeToken<T> token) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            InputStreamReader reader = new InputStreamReader(stream, encoding);
            String json = IOUtils.toString((Reader)reader);
            this.logger.debug("JSON:\n\n{}\n\n", (Object)json);
            Object result = this.getGson(token.getType()).fromJson(json, token.getType());
            return (T)result;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Failed to deserialize type: {}. Error: {}", new Object[]{e, token.getType(), e.getMessage()});
            throw new RuntimeException("Cannot read stream.");
        }
        catch (IOException e) {
            this.logger.error("Failed to deserialize type: {}. Error: {}", new Object[]{e, token.getType(), e.getMessage()});
            throw new RuntimeException("Cannot read stream.");
        }
    }

    public <T> Listing<T> listingFromStream(InputStream stream, String encoding, TypeToken<Listing<T>> token, DeserializerPostProcessor<T> ... postProcessors) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            Listing result = (Listing)this.getGson(null).fromJson((Reader)new InputStreamReader(stream, encoding), token.getType());
            if (result != null && result.getItems() != null) {
                List items = result.getItems();
                Collections.reverse(items);
                result = new Listing(items);
                for (Object item : result.getItems()) {
                    for (DeserializerPostProcessor proc : postProcessors) {
                        proc.process(item);
                    }
                }
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Failed to deserialize type: {}. Error: {}", new Object[]{e, token.getType(), e.getMessage()});
            throw new RuntimeException("Cannot read stream.");
        }
    }

    public <T> Listing<T> listingFromString(String src, TypeToken<Listing<T>> token, DeserializerPostProcessor<T> ... postProcessors) {
        Listing result = (Listing)this.getGson(null).fromJson(src, token.getType());
        if (result != null && result.getItems() != null) {
            List items = result.getItems();
            Collections.reverse(items);
            result = new Listing(items);
            for (Object item : result.getItems()) {
                for (DeserializerPostProcessor proc : postProcessors) {
                    proc.process(item);
                }
            }
        }
        return result;
    }
}

