/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.rest;

import java.io.IOException;
import java.util.Date;
import org.commonjava.freeki.data.GitManager;
import org.commonjava.util.logging.Logger;
import org.commonjava.vertx.vabr.Method;
import org.commonjava.vertx.vabr.RouteHandler;
import org.commonjava.vertx.vabr.anno.Route;
import org.commonjava.vertx.vabr.anno.Routes;
import org.vertx.java.core.http.HttpServerRequest;

public class UpdateHandler
implements RouteHandler {
    private final Logger logger = new Logger(this.getClass());
    private final GitManager git;

    public UpdateHandler(GitManager git) {
        this.git = git;
    }

    @Routes(value={@Route(path="/update/content", method=Method.POST), @Route(path="/update/pull", method=Method.POST)})
    public void pull(HttpServerRequest req) {
        try {
            this.git.pullUpdates();
            req.response().end();
        }
        catch (IOException e) {
            this.logger.error("Failed to pull updates: %s", e, e.getMessage());
            req.response().setStatusCode(500).setStatusMessage("Failed to pull content: " + e.getMessage()).end();
        }
    }

    @Routes(value={@Route(path="/update/push", method=Method.POST)})
    public void push(HttpServerRequest req) {
        String user = req.headers().get("user");
        String password = req.headers().get("password");
        try {
            this.git.pushUpdates(user, password);
            req.response().end();
            this.logger.info("Pushed content at: %s", new Date());
        }
        catch (IOException e) {
            this.logger.error("Failed to push updates: %s", e, e.getMessage());
            req.response().setStatusCode(500).setStatusMessage("Failed to push content: " + e.getMessage()).end();
        }
    }
}

