/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.rest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.commonjava.freeki.conf.FreekiConfig;
import org.commonjava.freeki.rest.PathParameter;
import org.commonjava.util.logging.Logger;
import org.commonjava.vertx.vabr.Method;
import org.commonjava.vertx.vabr.RouteHandler;
import org.commonjava.vertx.vabr.anno.Route;
import org.commonjava.vertx.vabr.anno.Routes;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

public class StaticContentHandler
implements RouteHandler,
Handler<HttpServerRequest> {
    private final Logger logger = new Logger(this.getClass());
    private final File staticBasedir;

    public StaticContentHandler(FreekiConfig mainConf) {
        this.staticBasedir = mainConf.getStaticDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Routes(value={@Route(path="/static/:path=(.+)", method=Method.GET)})
    public void get(HttpServerRequest req) {
        File f;
        req.response().setStatusCode(200);
        String path = req.params().get(PathParameter.PATH.param());
        if (path == null) {
            req.response().setStatusMessage("Not found").setStatusCode(404).end();
        }
        if (!(f = new File(this.staticBasedir, path)).exists()) {
            String resource = "static/" + path;
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            if (stream == null) {
                req.response().setStatusMessage("Not found").setStatusCode(404).end();
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                IOUtils.copy(stream, (OutputStream)baos);
            }
            catch (IOException e) {
                this.logger.error("Failed to read static resource: %s. Reason: %s", e, resource, e.getMessage());
                req.response().setStatusCode(500).setStatusMessage(path + " could not be read.").end();
                return;
            }
            try {
                int len = baos.toByteArray().length;
                Buffer buf = new Buffer(baos.toByteArray());
                req.response().putHeader("Content-Length", Integer.toString(len)).end(buf);
                return;
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        if (f.isDirectory()) {
            req.response().setStatusMessage("Content is a directory").setStatusCode(404).end();
            return;
        } else {
            req.response().sendFile(f.getAbsolutePath());
        }
    }

    @Override
    public void handle(HttpServerRequest req) {
        req.params().add(PathParameter.PATH.param(), req.absoluteURI().getPath());
        this.get(req);
    }
}

