/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.conf;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.commonjava.freeki.conf.FreekiConfig;
import org.commonjava.freeki.util.ContentType;
import org.commonjava.web.config.ConfigurationException;
import org.commonjava.web.config.section.MapSectionListener;

public class GTemplateConfig
extends MapSectionListener {
    private Map<ContentKey, String> templates;
    private final FreekiConfig config;

    public GTemplateConfig(Map<String, String> rawTemplateMap, FreekiConfig config) {
        this.config = config;
        this.parseRawTemplateMap(rawTemplateMap);
    }

    public File getBrandingDir() {
        return this.config.getBrandingDir();
    }

    public boolean isReadOnly() {
        return this.config.isReadOnly();
    }

    public String getTemplate(ContentType type, String renderKey) {
        return this.templates.get(new ContentKey(type, renderKey));
    }

    @Override
    public void sectionComplete(String name) throws ConfigurationException {
        super.sectionComplete(name);
        Object configuration = super.getConfiguration();
        this.parseRawTemplateMap((Map<String, String>)configuration);
    }

    private void parseRawTemplateMap(Map<String, String> rawTemplateMap) {
        HashMap<ContentKey, String> templates = new HashMap<ContentKey, String>();
        for (Map.Entry<String, String> entry : rawTemplateMap.entrySet()) {
            ContentType type;
            String[] keyParts;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || (keyParts = key.split("@")).length < 2 || (type = ContentType.find(keyParts[1])) == null) continue;
            ContentKey ck = new ContentKey(type, keyParts[0]);
            templates.put(ck, value);
        }
        this.templates = templates;
    }

    private static final class ContentKey {
        private final ContentType type;
        private final String renderKey;

        private ContentKey(ContentType type, String renderKey) {
            this.type = type;
            this.renderKey = renderKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.renderKey == null ? 0 : this.renderKey.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContentKey other = (ContentKey)obj;
            if (this.renderKey == null ? other.renderKey != null : !this.renderKey.equals(other.renderKey)) {
                return false;
            }
            return this.type == other.type;
        }
    }
}

