/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.AbstractSerializer;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.DefaultSerializer;
import com.hazelcast.nio.FastByteArrayInputStream;
import com.hazelcast.nio.FastByteArrayOutputStream;
import com.hazelcast.nio.TypeSerializer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Serializer
extends AbstractSerializer {
    private static final byte SERIALIZER_TYPE_DATA = 0;

    public Serializer() {
        super(new DataSerializer(), new DefaultSerializer());
    }

    public static Object newInstance(String className) throws Exception {
        return AbstractSerializer.newInstance(Serializer.loadClass(className));
    }

    public static Object newInstance(Class klass) throws Exception {
        return AbstractSerializer.newInstance(klass);
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        return AbstractSerializer.loadClass(className);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return AbstractSerializer.loadClass(classLoader, className);
    }

    public Data writeObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return (Data)obj;
        }
        byte[] bytes = this.toByteArray(obj);
        if (bytes == null) {
            return null;
        }
        Data data = new Data(bytes);
        if (obj instanceof PartitionAware) {
            Data partitionKey = this.writeObject(((PartitionAware)obj).getPartitionKey());
            int partitionHash = partitionKey == null ? -1 : partitionKey.getPartitionHash();
            data.setPartitionHash(partitionHash);
        }
        return data;
    }

    public Object readObject(Data data) {
        if (data == null || data.buffer == null || data.buffer.length == 0) {
            return null;
        }
        byte[] byteArray = data.buffer;
        Object obj = this.toObject(byteArray);
        ManagedContext managedContext = ThreadContext.get().getCurrentManagedContext();
        if (managedContext != null) {
            obj = managedContext.initialize(obj);
        }
        return obj;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataSerializer
    implements TypeSerializer<DataSerializable> {
        @Override
        public final int priority() {
            return 0;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof DataSerializable;
        }

        @Override
        public final byte getTypeId() {
            return 0;
        }

        protected Class loadClass(String className) throws ClassNotFoundException {
            return AbstractSerializer.loadClass(className);
        }

        protected String toClassName(Object obj) throws ClassNotFoundException {
            return obj.getClass().getName();
        }

        @Override
        public final DataSerializable read(FastByteArrayInputStream bbis) throws Exception {
            String className = bbis.readUTF();
            try {
                DataSerializable ds = (DataSerializable)Serializer.newInstance(this.loadClass(className));
                ds.readData(bbis);
                return ds;
            }
            catch (Exception e) {
                throw new IOException("Problem reading DataSerializable class : " + className + ", exception: " + e);
            }
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, DataSerializable obj) throws Exception {
            bbos.writeUTF(this.toClassName(obj));
            obj.writeData(bbos);
        }
    }
}

