/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.util;

import java.net.MalformedURLException;
import java.net.URL;

public final class UrlInfo {
    private final String url;
    private String user;
    private String password;
    private final String host;
    private int port;
    private final String rawUrl;

    UrlInfo(String u) {
        URL url;
        this.rawUrl = u;
        String resultUrl = u;
        try {
            url = new URL(u);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to parse repository URL: '" + u + "'. Reason: " + e.getMessage(), e);
        }
        String userInfo = url.getUserInfo();
        if (userInfo != null && this.user == null && this.password == null) {
            this.user = userInfo;
            this.password = null;
            int idx = userInfo.indexOf(58);
            if (idx > 0) {
                this.user = userInfo.substring(0, idx);
                this.password = userInfo.substring(idx + 1);
                StringBuilder sb = new StringBuilder();
                idx = this.url.indexOf("://");
                sb.append(this.url.substring(0, idx + 3));
                idx = this.url.indexOf("@");
                if (idx > 0) {
                    sb.append(this.url.substring(idx + 1));
                }
                resultUrl = sb.toString();
            }
        }
        this.url = resultUrl;
        this.host = url.getHost();
        this.port = url.getPort() < 0 ? (url.getProtocol().equals("https") ? 443 : 80) : url.getPort();
    }

    public String getRawUrl() {
        return this.rawUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

