/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.model.io;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.commonjava.web.json.ser.WebSerializationAdapter;

public class DateSerializer
implements WebSerializationAdapter,
JsonSerializer<Date>,
JsonDeserializer<Date> {
    public static final String DATE_FORMAT = "yyyy-MM-dd kk:mm Z";

    @Override
    public void register(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter((Type)((Object)Date.class), this);
    }

    @Override
    public Date deserialize(JsonElement src, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        String s = src.getAsString();
        if (s.trim().length() < 1) {
            return null;
        }
        try {
            return DateSerializer.parseDate(s);
        }
        catch (ParseException e) {
            throw new JsonParseException(String.format("Failed to parse date: '%s'. Reason: %s", s, e.getMessage()), e);
        }
    }

    public static Date parseDate(String s) throws ParseException {
        return new SimpleDateFormat(DATE_FORMAT).parse(s);
    }

    @Override
    public JsonElement serialize(Date src, Type type, JsonSerializationContext ctx) {
        return new JsonPrimitive(src == null ? "" : DateSerializer.formatDate(src));
    }

    public static String formatDate(Date src) {
        return new SimpleDateFormat(DATE_FORMAT).format(src);
    }
}

