/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LoggerFactorySupport;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jFactory
extends LoggerFactorySupport {
    protected ILogger createLogger(String name) {
        Logger l = LoggerFactory.getLogger(name);
        return new Slf4jLogger(l);
    }

    class Slf4jLogger
    implements ILogger {
        private final Logger logger;

        public Slf4jLogger(Logger logger) {
            this.logger = logger;
        }

        public void log(Level level, String message) {
            if (Level.FINEST == level) {
                this.logger.debug(message);
            } else if (Level.SEVERE == level) {
                this.logger.error(message);
            } else if (Level.WARNING == level) {
                this.logger.warn(message);
            } else {
                this.logger.info(message);
            }
        }

        public Level getLevel() {
            if (this.logger.isErrorEnabled()) {
                return Level.SEVERE;
            }
            if (this.logger.isWarnEnabled()) {
                return Level.WARNING;
            }
            if (this.logger.isInfoEnabled()) {
                return Level.INFO;
            }
            return Level.FINEST;
        }

        public boolean isLoggable(Level level) {
            if (Level.FINEST == level) {
                return this.logger.isDebugEnabled();
            }
            if (Level.INFO == level) {
                return this.logger.isInfoEnabled();
            }
            if (Level.WARNING == level) {
                return this.logger.isWarnEnabled();
            }
            if (Level.SEVERE == level) {
                return this.logger.isErrorEnabled();
            }
            return this.logger.isInfoEnabled();
        }

        public void log(Level level, String message, Throwable thrown) {
            if (Level.FINEST == level) {
                this.logger.debug(message, thrown);
            } else if (Level.INFO == level) {
                this.logger.info(message, thrown);
            } else if (Level.WARNING == level) {
                this.logger.warn(message, thrown);
            } else if (Level.SEVERE == level) {
                this.logger.error(message, thrown);
            } else {
                this.logger.info(message, thrown);
            }
        }

        public void log(LogEvent logEvent) {
            LogRecord logRecord = logEvent.getLogRecord();
            Level level = logEvent.getLogRecord().getLevel();
            String message = logRecord.getMessage();
            Throwable thrown = logRecord.getThrown();
            this.log(level, message, thrown);
        }
    }
}

