/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.client;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.channels.UnresolvedAddressException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.MessageClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.common.TransportException;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClient;
import org.eclipse.jetty.websocket.WebSocketClientFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketTransport
extends HttpClientTransport
implements MessageClientTransport {
    public static final String PREFIX = "ws";
    public static final String NAME = "websocket";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String CONNECT_TIMEOUT_OPTION = "connectTimeout";
    public static final String IDLE_TIMEOUT_OPTION = "idleTimeout";
    public static final String MAX_MESSAGE_SIZE_OPTION = "maxMessageSize";
    public static final String STICKY_RECONNECT_OPTION = "stickyReconnect";
    private final WebSocketClientFactory _webSocketClientFactory;
    private ScheduledExecutorService _scheduler;
    private boolean _shutdownScheduler;
    private String _protocol;
    private long _connectTimeout;
    private int _idleTimeout;
    private int _maxMessageSize;
    private boolean _stickyReconnect;
    private boolean _webSocketSupported;
    private boolean _webSocketConnected;
    private Delegate _delegate;
    private TransportListener _listener;

    public static WebSocketTransport create(Map<String, Object> options, WebSocketClientFactory webSocketClientFactory) {
        return WebSocketTransport.create(options, webSocketClientFactory, null);
    }

    public static WebSocketTransport create(Map<String, Object> options, WebSocketClientFactory webSocketClientFactory, ScheduledExecutorService scheduler) {
        WebSocketTransport transport = new WebSocketTransport(options, webSocketClientFactory, scheduler);
        if (!webSocketClientFactory.isStarted()) {
            try {
                webSocketClientFactory.start();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return transport;
    }

    public WebSocketTransport(Map<String, Object> options, WebSocketClientFactory webSocketClientFactory, ScheduledExecutorService scheduler) {
        this(null, options, webSocketClientFactory, scheduler);
    }

    public WebSocketTransport(String url, Map<String, Object> options, WebSocketClientFactory webSocketClientFactory, ScheduledExecutorService scheduler) {
        super(NAME, url, options);
        this._webSocketClientFactory = webSocketClientFactory;
        this._scheduler = scheduler;
        this.setOptionPrefix(PREFIX);
        this._webSocketSupported = true;
    }

    public void setMessageTransportListener(TransportListener listener) {
        this._listener = listener;
    }

    public boolean accept(String version) {
        return this._webSocketSupported;
    }

    public void init() {
        super.init();
        if (this._scheduler == null) {
            this._scheduler = Executors.newSingleThreadScheduledExecutor();
            this._shutdownScheduler = true;
        }
        this._protocol = this.getOption(PROTOCOL_OPTION, this._protocol);
        this.setMaxNetworkDelay(15000L);
        this._connectTimeout = 30000L;
        this._idleTimeout = 60000;
        this._maxMessageSize = this.getOption(MAX_MESSAGE_SIZE_OPTION, this._webSocketClientFactory.getBufferSize());
        this._stickyReconnect = this.getOption(STICKY_RECONNECT_OPTION, true);
    }

    private long getConnectTimeout() {
        this._connectTimeout = this.getOption(CONNECT_TIMEOUT_OPTION, this._connectTimeout);
        return this._connectTimeout;
    }

    private int getIdleTimeout() {
        this._idleTimeout = this.getOption(IDLE_TIMEOUT_OPTION, this._idleTimeout);
        return this._idleTimeout;
    }

    public void abort() {
        Delegate delegate = this.getDelegate();
        if (delegate != null) {
            delegate.abort();
        }
        this.shutdownScheduler();
    }

    public void terminate() {
        Delegate delegate = this.getDelegate();
        if (delegate != null) {
            delegate.terminate();
        }
        this.shutdownScheduler();
        super.terminate();
    }

    private void shutdownScheduler() {
        if (this._shutdownScheduler) {
            this._shutdownScheduler = false;
            this._scheduler.shutdownNow();
            this._scheduler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Delegate getDelegate() {
        WebSocketTransport webSocketTransport = this;
        synchronized (webSocketTransport) {
            return this._delegate;
        }
    }

    public void send(TransportListener listener, Message.Mutable ... messages) {
        Delegate delegate = this.getDelegate();
        if (delegate == null && (delegate = this.connect(listener, messages)) == null) {
            return;
        }
        delegate.registerMessages(listener, messages);
        try {
            String json = this.generateJSON(messages);
            this.debug("Sending messages {}", new Object[]{json});
            listener.onSending((Message[])messages);
            delegate.send(json);
        }
        catch (Exception x) {
            delegate.fail(x, "Exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Delegate connect(TransportListener listener, Message.Mutable[] messages) {
        try {
            String url = this.getURL();
            url = url.replaceFirst("^http", PREFIX);
            URI uri = new URI(url);
            this.debug("Opening websocket connection to {}", new Object[]{uri});
            HashMap<String, String> cookies = new HashMap<String, String>();
            for (HttpClientTransport.Cookie cookie : this.getCookieProvider().getCookies()) {
                cookies.put(cookie.getName(), cookie.getValue());
            }
            WebSocketClient client = this.newWebSocketClient();
            client.setProtocol(this._protocol);
            client.getCookies().putAll(cookies);
            Delegate delegate = this.connect(client, uri);
            WebSocketTransport webSocketTransport = this;
            synchronized (webSocketTransport) {
                if (this._delegate != null) {
                    delegate.close("Extra");
                    delegate = this._delegate;
                }
                this._delegate = delegate;
            }
            this._webSocketConnected = true;
            return delegate;
        }
        catch (ConnectException x) {
            listener.onConnectException((Throwable)x, (Message[])messages);
        }
        catch (UnresolvedAddressException x) {
            listener.onConnectException((Throwable)x, (Message[])messages);
        }
        catch (SocketTimeoutException x) {
            listener.onConnectException((Throwable)x, (Message[])messages);
        }
        catch (TimeoutException x) {
            listener.onConnectException((Throwable)x, (Message[])messages);
        }
        catch (InterruptedException x) {
            listener.onConnectException((Throwable)x, (Message[])messages);
        }
        catch (ProtocolException x) {
            int code;
            this._webSocketSupported = false;
            HashMap<String, Integer> failure = new HashMap<String, Integer>(2);
            failure.put("websocketCode", 1002);
            Matcher matcher = Pattern.compile("(\\d+){3}").matcher(x.getMessage());
            if (matcher.find() && (code = Integer.parseInt(matcher.group())) > 100 && code < 600) {
                failure.put("httpCode", code);
            }
            listener.onException((Throwable)new TransportException((Throwable)x, failure), (Message[])messages);
        }
        catch (Exception x) {
            this._webSocketSupported = this._stickyReconnect && this._webSocketConnected;
            listener.onException((Throwable)x, (Message[])messages);
        }
        return null;
    }

    protected Delegate connect(WebSocketClient client, URI uri) throws IOException, InterruptedException, TimeoutException {
        Delegate result = this.newDelegate();
        client.open(uri, (WebSocket)result, this.getConnectTimeout(), TimeUnit.MILLISECONDS);
        return result;
    }

    protected WebSocketClient newWebSocketClient() {
        WebSocketClient result = this._webSocketClientFactory.newWebSocketClient();
        result.setMaxTextMessageSize(this._maxMessageSize);
        result.setMaxIdleTime(this.getIdleTimeout());
        return result;
    }

    protected Delegate newDelegate() {
        return new Delegate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WebSocketExchange {
        private final Message.Mutable message;
        private final TransportListener listener;
        private final ScheduledFuture<?> task;

        public WebSocketExchange(Message.Mutable message, TransportListener listener, ScheduledFuture<?> task) {
            this.message = message;
            this.listener = listener;
            this.task = task;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Delegate
    implements WebSocket.OnTextMessage {
        private final Map<String, WebSocketExchange> _exchanges = new ConcurrentHashMap<String, WebSocketExchange>();
        private WebSocket.Connection _connection;
        private volatile boolean _connected;
        private volatile boolean _disconnected;
        private volatile Map<String, Object> _advice;

        protected Delegate() {
        }

        public void onOpen(WebSocket.Connection connection) {
            this.setConnection(connection);
            WebSocketTransport.this.debug("Opened websocket connection {}", new Object[]{connection});
        }

        public void onClose(int closeCode, String message) {
            if (this.detach()) {
                WebSocketTransport.this.debug("Closed websocket connection {}/{}", new Object[]{closeCode, message});
                this.setConnection(null);
                this.failMessages(new EOFException("Connection closed " + closeCode + " " + message));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setConnection(WebSocket.Connection connection) {
            Delegate delegate = this;
            synchronized (delegate) {
                this._connection = connection;
            }
        }

        public void onMessage(String data) {
            try {
                List messages = WebSocketTransport.this.parseMessages(data);
                if (this.isAttached()) {
                    WebSocketTransport.this.debug("Received messages {}", new Object[]{data});
                    this.onMessages(messages);
                } else {
                    WebSocketTransport.this.debug("Discarding messages {}", new Object[]{messages});
                }
            }
            catch (ParseException x) {
                this.fail(x, "Exception");
            }
        }

        protected void onMessages(List<Message.Mutable> messages) {
            for (Message.Mutable message : messages) {
                if (this.isReply((Message)message)) {
                    WebSocketExchange exchange;
                    Map advice;
                    if ("/meta/connect".equals(message.getChannel()) && message.isSuccessful() && (advice = message.getAdvice()) != null && advice.get("timeout") != null) {
                        this._advice = advice;
                    }
                    if ((exchange = this.deregisterMessage((Message)message)) != null) {
                        exchange.listener.onMessages(Collections.singletonList(message));
                    } else {
                        WebSocketTransport.this.debug("Could not find request for reply {}", new Object[]{message});
                    }
                    if (!this._disconnected || this._connected) continue;
                    this.disconnect("Disconnect");
                    continue;
                }
                WebSocketTransport.this._listener.onMessages(Collections.singletonList(message));
            }
        }

        private boolean isReply(Message message) {
            return message.isMeta() || message.isPublishReply();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerMessages(TransportListener listener, Message.Mutable[] messages) {
            boolean active;
            Delegate delegate = this;
            synchronized (delegate) {
                boolean bl = active = this._connection != null;
                if (active) {
                    for (Message.Mutable message : messages) {
                        this.registerMessage(message, listener);
                    }
                }
            }
            if (!active) {
                listener.onException((Throwable)new IOException("Aborted"), (Message[])messages);
            }
        }

        private void registerMessage(final Message.Mutable message, TransportListener listener) {
            long maxNetworkDelay = WebSocketTransport.this.getMaxNetworkDelay();
            if ("/meta/connect".equals(message.getChannel())) {
                Map<String, Object> advice = message.getAdvice();
                if (advice == null) {
                    advice = this._advice;
                }
                if (advice != null) {
                    Object timeout = advice.get("timeout");
                    if (timeout instanceof Number) {
                        maxNetworkDelay += (long)((Number)timeout).intValue();
                    } else if (timeout != null) {
                        maxNetworkDelay += (long)Integer.parseInt(timeout.toString());
                    }
                }
                this._connected = true;
            }
            final long expiration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + maxNetworkDelay;
            ScheduledFuture<?> task = WebSocketTransport.this._scheduler.schedule(new Runnable(){

                public void run() {
                    long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    long delay = now - expiration;
                    if (delay > 5000L) {
                        WebSocketTransport.this.debug("Message {} expired {} ms too late", new Object[]{message, delay});
                    }
                    WebSocketTransport.this.debug("Expiring message {}", new Object[]{message});
                    Delegate.this.fail(new TimeoutException(), "Expired");
                }
            }, maxNetworkDelay, TimeUnit.MILLISECONDS);
            WebSocketExchange exchange = new WebSocketExchange(message, listener, task);
            WebSocketTransport.this.debug("Registering {}", new Object[]{exchange});
            WebSocketExchange existing = this._exchanges.put(message.getId(), exchange);
            if (existing != null) {
                throw new IllegalStateException();
            }
        }

        private WebSocketExchange deregisterMessage(Message message) {
            WebSocketExchange exchange = this._exchanges.remove(message.getId());
            if ("/meta/connect".equals(message.getChannel())) {
                this._connected = false;
            } else if ("/meta/disconnect".equals(message.getChannel())) {
                this._disconnected = true;
            }
            WebSocketTransport.this.debug("Deregistering {} for message {}", new Object[]{exchange, message});
            if (exchange != null) {
                exchange.task.cancel(false);
            }
            return exchange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send(String text) throws IOException {
            WebSocket.Connection connection;
            Delegate delegate = this;
            synchronized (delegate) {
                connection = this._connection;
            }
            if (connection == null) {
                throw new IOException("Could not send " + text);
            }
            connection.sendMessage(text);
        }

        private void fail(Exception failure, String reason) {
            this.disconnect(reason);
            this.failMessages(failure);
        }

        private void failMessages(Throwable cause) {
            for (WebSocketExchange exchange : new ArrayList<WebSocketExchange>(this._exchanges.values())) {
                Message.Mutable message = exchange.message;
                if (this.deregisterMessage((Message)message) != exchange) continue;
                exchange.listener.onException(cause, new Message[]{message});
            }
        }

        public void abort() {
            this.fail(new IOException("Aborted"), "Aborted");
        }

        private void disconnect(String reason) {
            if (this.detach()) {
                this.close(reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isAttached() {
            WebSocketTransport webSocketTransport = WebSocketTransport.this;
            synchronized (webSocketTransport) {
                return this == WebSocketTransport.this._delegate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean detach() {
            WebSocketTransport webSocketTransport = WebSocketTransport.this;
            synchronized (webSocketTransport) {
                boolean attached;
                boolean bl = attached = this == WebSocketTransport.this._delegate;
                if (attached) {
                    WebSocketTransport.this._delegate = null;
                }
                return attached;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(String reason) {
            WebSocket.Connection connection;
            Delegate delegate = this;
            synchronized (delegate) {
                connection = this._connection;
                this.setConnection(null);
            }
            if (connection != null) {
                WebSocketTransport.this.debug("Closing ({}) websocket connection {}", new Object[]{reason, connection});
                connection.close(1000, reason);
            }
        }

        private void terminate() {
            this.fail(new EOFException(), "Terminate");
        }
    }
}

