/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.filter;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.filter.DataFilter;

public class JSONDataFilter
implements DataFilter {
    public void init(Object init) {
    }

    @Override
    public Object filter(ServerSession from, ServerChannel to, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Map) {
            return this.filterMap(from, to, (Map)data);
        }
        if (data instanceof List) {
            return this.filterArray(from, to, ((List)data).toArray());
        }
        if (data instanceof Collection) {
            return this.filterArray(from, to, ((Collection)data).toArray());
        }
        if (data.getClass().isArray()) {
            return this.filterArray(from, to, data);
        }
        if (data instanceof Number) {
            return this.filterNumber((Number)data);
        }
        if (data instanceof Boolean) {
            return this.filterBoolean((Boolean)data);
        }
        if (data instanceof String) {
            return this.filterString((String)data);
        }
        return this.filterObject(from, to, data);
    }

    protected Object filterString(String string) {
        return string;
    }

    protected Object filterBoolean(Boolean bool) {
        return bool;
    }

    protected Object filterNumber(Number number) {
        return number;
    }

    protected Object filterArray(ServerSession from, ServerChannel to, Object array) {
        if (array == null) {
            return null;
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.filter(from, to, Array.get(array, i)));
        }
        return array;
    }

    protected Object filterMap(ServerSession from, ServerChannel to, Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            entry.setValue(this.filter(from, to, entry.getValue()));
        }
        return map;
    }

    protected Object filterObject(ServerSession from, ServerChannel to, Object obj) {
        return obj;
    }
}

