/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityExtension
extends BayeuxServer.Extension.Adapter {
    private final Activity activity;
    private final long maxInactivityPeriod;

    public ActivityExtension(Activity activity, long maxInactivityPeriod) {
        this.activity = activity;
        this.maxInactivityPeriod = maxInactivityPeriod;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public long getMaxInactivityPeriod() {
        return this.maxInactivityPeriod;
    }

    public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
        if ("/meta/handshake".equals(message.getChannel()) && message.isSuccessful()) {
            to.addExtension(this.newSessionExtension(to, (ServerMessage)message));
        }
        return true;
    }

    protected ServerSession.Extension newSessionExtension(ServerSession session, ServerMessage handshakeReply) {
        return new SessionExtension(this.getActivity(), this.getMaxInactivityPeriod());
    }

    public static class SessionExtension
    implements ServerSession.Extension {
        private static final Logger logger = LoggerFactory.getLogger(ActivityExtension.class);
        private final AtomicLong lastActivity = new AtomicLong(System.nanoTime());
        private final Activity activity;
        private final long maxInactivityPeriod;

        public SessionExtension(Activity activity, long maxInactivityPeriod) {
            this.activity = activity;
            this.maxInactivityPeriod = maxInactivityPeriod;
        }

        public long getMaxInactivityPeriod() {
            return this.maxInactivityPeriod;
        }

        protected long getLastActivity() {
            return this.lastActivity.get();
        }

        public boolean rcv(ServerSession session, ServerMessage.Mutable message) {
            logger.debug("Marking active session {}, received message {}", (Object)session, (Object)message);
            this.markActive();
            return true;
        }

        public boolean rcvMeta(ServerSession session, ServerMessage.Mutable message) {
            if ("/meta/connect".equals(message.getChannel())) {
                if (this.isInactive()) {
                    logger.debug("Inactive session {}, disconnecting", (Object)session);
                    this.disconnect(session);
                }
            } else {
                logger.debug("Marking active session {}, received meta message {}", (Object)session, (Object)message);
                this.markActive();
            }
            return true;
        }

        public ServerMessage send(ServerSession session, ServerMessage message) {
            if (this.activity == Activity.CLIENT_SERVER) {
                logger.debug("Marking active session {}, sending message {}", (Object)session, (Object)message);
                this.markActive();
            }
            return message;
        }

        public boolean sendMeta(ServerSession session, ServerMessage.Mutable message) {
            if (!"/meta/connect".equals(message.getChannel()) && this.activity == Activity.CLIENT_SERVER) {
                logger.debug("Marking active session {}, sending meta message {}", (Object)session, (Object)message);
                this.markActive();
            }
            return true;
        }

        protected void markActive() {
            this.lastActivity.set(System.nanoTime());
        }

        protected boolean isInactive() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.getLastActivity()) > this.getMaxInactivityPeriod();
        }

        protected void disconnect(ServerSession session) {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public static enum Activity {
        CLIENT,
        CLIENT_SERVER;

    }
}

