/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Map;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ext.AcknowledgedMessagesClientExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgedMessagesExtension
extends BayeuxServer.Extension.Adapter {
    private final Logger _logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
        if ("/meta/handshake".equals(message.getChannel()) && Boolean.TRUE.equals(message.get((Object)"successful"))) {
            boolean clientRequestedAcks;
            ServerMessage.Mutable rcv = message.getAssociated();
            Map rcvExt = rcv.getExt();
            boolean bl = clientRequestedAcks = rcvExt != null && rcvExt.get("ack") == Boolean.TRUE;
            if (clientRequestedAcks && to != null) {
                this._logger.debug("Enabled message acknowledgement for client {}", (Object)to);
                to.addExtension((ServerSession.Extension)new AcknowledgedMessagesClientExtension(to));
                ((ServerSessionImpl)to).setMetaConnectDeliveryOnly(true);
            }
            Map sndExt = message.getExt(true);
            sndExt.put("ack", Boolean.TRUE);
        }
        return true;
    }
}

