/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Invoker> invokers = new ConcurrentHashMap<String, Invoker>();
    private final String _name;
    private final BayeuxServerImpl _bayeux;
    private final LocalSession _session;
    private ThreadPool _threadPool;
    private boolean _seeOwn = false;

    public AbstractService(BayeuxServer bayeux, String name) {
        this(bayeux, name, 0);
    }

    public AbstractService(BayeuxServer bayeux, String name, int maxThreads) {
        this._name = name;
        this._bayeux = (BayeuxServerImpl)bayeux;
        this._session = this._bayeux.newLocalSession(name);
        this._session.handshake();
        if (maxThreads > 0) {
            this.setThreadPool((ThreadPool)new QueuedThreadPool(maxThreads));
        }
    }

    public BayeuxServer getBayeux() {
        return this._bayeux;
    }

    public LocalSession getLocalSession() {
        return this._session;
    }

    public ServerSession getServerSession() {
        return this._session.getServerSession();
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        try {
            if (pool instanceof LifeCycle && !((LifeCycle)pool).isStarted()) {
                ((LifeCycle)pool).start();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this._threadPool = pool;
    }

    public boolean isSeeOwnPublishes() {
        return this._seeOwn;
    }

    public void setSeeOwnPublishes(boolean seeOwnPublishes) {
        this._seeOwn = seeOwnPublishes;
    }

    protected void addService(String channelName, String methodName) {
        this._logger.debug("Mapping {}#{} to {}", new Object[]{this._name, methodName, channelName});
        Method method = null;
        for (Class<?> c = this.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            Method[] methods = c.getDeclaredMethods();
            int i = methods.length;
            while (i-- > 0) {
                if (!methodName.equals(methods[i].getName())) continue;
                if (method != null) {
                    throw new IllegalArgumentException("Multiple methods called '" + methodName + "'");
                }
                method = methods[i];
            }
        }
        if (method == null) {
            throw new NoSuchMethodError(methodName);
        }
        int params = method.getParameterTypes().length;
        if (params < 2 || params > 4) {
            throw new IllegalArgumentException("Method '" + methodName + "' does not have 2, 3 or 4 parameters");
        }
        if (!ServerSession.class.isAssignableFrom(method.getParameterTypes()[0])) {
            throw new IllegalArgumentException("Method '" + methodName + "' does not have Session as first parameter");
        }
        this._bayeux.createIfAbsent(channelName, new ConfigurableServerChannel.Initializer[0]);
        ServerChannel channel = this._bayeux.getChannel(channelName);
        Invoker invoker = new Invoker(channelName, method);
        this.invokers.put(methodName, invoker);
        channel.addListener((ConfigurableServerChannel.ServerChannelListener)invoker);
    }

    protected void removeService(String channelName, String methodName) {
        ServerChannel channel = this._bayeux.getChannel(channelName);
        if (channel != null) {
            Invoker invoker = this.invokers.remove(methodName);
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)invoker);
        }
    }

    protected void removeService(String channelName) {
        ServerChannel channel = this._bayeux.getChannel(channelName);
        if (channel != null) {
            for (Invoker invoker : this.invokers.values()) {
                if (!invoker.channelName.equals(channelName)) continue;
                channel.removeListener((ConfigurableServerChannel.ServerChannelListener)invoker);
            }
        }
    }

    protected void send(ServerSession toClient, String onChannel, Object data, String id) {
        toClient.deliver((Session)this._session.getServerSession(), onChannel, data, id);
    }

    protected void exception(String method, ServerSession fromClient, LocalSession toClient, ServerMessage msg, Throwable x) {
        this._logger.info("Exception while invoking " + this._name + "#" + method + " from " + fromClient + " with " + msg, x);
    }

    private void invoke(final Method method, final ServerSession fromClient, final ServerMessage msg) {
        this._logger.debug("Invoking {}#{} from {} with {}", new Object[]{this._name, method.getName(), fromClient, msg});
        ThreadPool threadPool = this.getThreadPool();
        if (threadPool == null) {
            this.doInvoke(method, fromClient, msg);
        } else {
            threadPool.dispatch(new Runnable(){

                public void run() {
                    AbstractService.this.doInvoke(method, fromClient, msg);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doInvoke(Method method, ServerSession fromClient, ServerMessage msg) {
        channel = msg.getChannel();
        data = msg.getData();
        id = msg.getId();
        if (method != null) {
            try {
                parameterTypes = method.getParameterTypes();
                messageParameterIndex = parameterTypes.length == 4 ? 2 : 1;
                messageArgument = data;
                if (Message.class.isAssignableFrom(parameterTypes[messageParameterIndex])) {
                    messageArgument = msg;
                }
                accessible = method.isAccessible();
                reply = null;
                try {
                    method.setAccessible(true);
                    switch (method.getParameterTypes().length) {
                        case 2: {
                            reply = method.invoke((Object)this, new Object[]{fromClient, messageArgument});
                            ** break;
lbl19:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            reply = method.invoke((Object)this, new Object[]{fromClient, messageArgument, id});
                            ** break;
lbl23:
                            // 1 sources

                            break;
                        }
                        case 4: {
                            reply = method.invoke((Object)this, new Object[]{fromClient, channel, messageArgument, id});
                            break;
                        }
                        ** default:
lbl28:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    method.setAccessible(accessible);
                }
                if (reply != null) {
                    this.send(fromClient, channel, reply, id);
                }
            }
            catch (Exception e) {
                this.exception(method.toString(), fromClient, this._session, msg, e);
            }
            catch (Error e) {
                this.exception(method.toString(), fromClient, this._session, msg, e);
            }
        }
    }

    private class Invoker
    implements ServerChannel.MessageListener {
        private final String channelName;
        private final Method method;

        public Invoker(String channelName, Method method) {
            this.channelName = channelName;
            this.method = method;
        }

        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (AbstractService.this.isSeeOwnPublishes() || from != AbstractService.this.getServerSession()) {
                AbstractService.this.invoke(this.method, from, (ServerMessage)message);
            }
            return true;
        }
    }
}

