/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.eclipse.jetty.util.AttributesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClientSession
implements ClientSession {
    protected static final String PUBLISH_CALLBACK_KEY = "org.cometd.client.publishCallback";
    protected static final Logger logger = LoggerFactory.getLogger(ClientSession.class);
    private static final AtomicLong _idGen = new AtomicLong(0L);
    private final List<ClientSession.Extension> _extensions = new CopyOnWriteArrayList<ClientSession.Extension>();
    private final AttributesMap _attributes = new AttributesMap();
    private final ConcurrentMap<String, AbstractSessionChannel> _channels = new ConcurrentHashMap<String, AbstractSessionChannel>();
    private final AtomicInteger _batch = new AtomicInteger();

    protected AbstractClientSession() {
    }

    protected String newMessageId() {
        return String.valueOf(_idGen.incrementAndGet());
    }

    public void addExtension(ClientSession.Extension extension) {
        this._extensions.add(extension);
    }

    public void removeExtension(ClientSession.Extension extension) {
        this._extensions.remove(extension);
    }

    public List<ClientSession.Extension> getExtensions() {
        return Collections.unmodifiableList(this._extensions);
    }

    protected boolean extendSend(Message.Mutable message) {
        if (message.isMeta()) {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.sendMeta((ClientSession)this, message)) continue;
                return false;
            }
        } else {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.send((ClientSession)this, message)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean extendRcv(Message.Mutable message) {
        if (message.isMeta()) {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.rcvMeta((ClientSession)this, message)) continue;
                return false;
            }
        } else {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.rcv((ClientSession)this, message)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract ChannelId newChannelId(String var1);

    protected abstract AbstractSessionChannel newChannel(ChannelId var1);

    public ClientSessionChannel getChannel(String channelId) {
        ChannelId id;
        AbstractSessionChannel new_channel;
        AbstractSessionChannel channel = (AbstractSessionChannel)this._channels.get(channelId);
        if (channel == null && (channel = this._channels.putIfAbsent(channelId, new_channel = this.newChannel(id = this.newChannelId(channelId)))) == null) {
            channel = new_channel;
        }
        return channel;
    }

    protected ConcurrentMap<String, AbstractSessionChannel> getChannels() {
        return this._channels;
    }

    public void startBatch() {
        this._batch.incrementAndGet();
    }

    protected abstract void sendBatch();

    public boolean endBatch() {
        if (this._batch.decrementAndGet() == 0) {
            this.sendBatch();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(Runnable batch) {
        this.startBatch();
        try {
            batch.run();
        }
        finally {
            this.endBatch();
        }
    }

    protected boolean isBatching() {
        return this._batch.get() > 0;
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    public Object removeAttribute(String name) {
        Object old = this._attributes.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    protected void resetSubscriptions() {
        for (AbstractSessionChannel ch : this._channels.values()) {
            ch.resetSubscriptions();
        }
    }

    public void receive(Message.Mutable message) {
        if (message.getChannel() == null) {
            throw new IllegalArgumentException("Bayeux messages must have a channel, " + message);
        }
        if (!this.extendRcv(message)) {
            return;
        }
        this.notifyListeners(message);
    }

    protected void notifyListeners(Message.Mutable message) {
        MarkableReference<AbstractSessionChannel> channelRef = this.getReleasableChannel(message.getChannel());
        AbstractSessionChannel channel = channelRef.getReference();
        channel.notifyMessageListeners((Message)message);
        if (channelRef.isMarked()) {
            channel.release();
        }
        ChannelId channelId = channel.getChannelId();
        for (String wildChannelName : channelId.getWilds()) {
            MarkableReference<AbstractSessionChannel> wildChannelRef = this.getReleasableChannel(wildChannelName);
            AbstractSessionChannel wildChannel = wildChannelRef.getReference();
            wildChannel.notifyMessageListeners((Message)message);
            if (!wildChannelRef.isMarked()) continue;
            wildChannel.release();
        }
    }

    protected void notifyListener(ClientSessionChannel.MessageListener listener, Message.Mutable message) {
        MarkableReference<AbstractSessionChannel> channelRef = this.getReleasableChannel(message.getChannel());
        AbstractSessionChannel channel = channelRef.getReference();
        channel.notifyOnMessage(listener, (Message)message);
        if (channelRef.isMarked()) {
            channel.release();
        }
    }

    private MarkableReference<AbstractSessionChannel> getReleasableChannel(String id) {
        AbstractSessionChannel channel;
        AbstractSessionChannel abstractSessionChannel = channel = ChannelId.isMeta((String)id) ? (AbstractSessionChannel)this.getChannel(id) : (AbstractSessionChannel)this.getChannels().get(id);
        if (channel != null) {
            return new MarkableReference<AbstractSessionChannel>(channel, false);
        }
        return new MarkableReference<AbstractSessionChannel>(this.newChannel(this.newChannelId(id)), true);
    }

    public void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append('\n');
        int leaves = this._channels.size();
        int i = 0;
        for (AbstractSessionChannel child : this._channels.values()) {
            b.append(indent);
            b.append(" +-");
            child.dump(b, indent + (++i == leaves ? "   " : " | "));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MarkableReference<T> {
        private final T reference;
        private final boolean mark;

        private MarkableReference(T reference, boolean mark) {
            this.reference = reference;
            this.mark = mark;
        }

        public T getReference() {
            return this.reference;
        }

        public boolean isMarked() {
            return this.mark;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractSessionChannel
    implements ClientSessionChannel {
        private final ChannelId _id;
        private final AttributesMap _attributes = new AttributesMap();
        private final CopyOnWriteArrayList<ClientSessionChannel.MessageListener> _subscriptions = new CopyOnWriteArrayList();
        private final AtomicInteger _subscriptionCount = new AtomicInteger();
        private final CopyOnWriteArrayList<ClientSessionChannel.ClientSessionChannelListener> _listeners = new CopyOnWriteArrayList();
        private volatile boolean _released;

        protected AbstractSessionChannel(ChannelId id) {
            this._id = id;
        }

        public ChannelId getChannelId() {
            return this._id;
        }

        public void addListener(ClientSessionChannel.ClientSessionChannelListener listener) {
            this.throwIfReleased();
            this._listeners.add(listener);
        }

        public void removeListener(ClientSessionChannel.ClientSessionChannelListener listener) {
            this.throwIfReleased();
            this._listeners.remove(listener);
        }

        public List<ClientSessionChannel.ClientSessionChannelListener> getListeners() {
            return Collections.unmodifiableList(this._listeners);
        }

        public void publish(Object data) {
            this.publish(data, null);
        }

        public void subscribe(ClientSessionChannel.MessageListener listener) {
            int count;
            this.throwIfReleased();
            boolean added = this._subscriptions.add(listener);
            if (added && (count = this._subscriptionCount.incrementAndGet()) == 1) {
                this.sendSubscribe();
            }
        }

        protected abstract void sendSubscribe();

        public void unsubscribe(ClientSessionChannel.MessageListener listener) {
            int count;
            this.throwIfReleased();
            boolean removed = this._subscriptions.remove(listener);
            if (removed && (count = this._subscriptionCount.decrementAndGet()) == 0) {
                this.sendUnSubscribe();
            }
        }

        protected abstract void sendUnSubscribe();

        public void unsubscribe() {
            this.throwIfReleased();
            for (ClientSessionChannel.MessageListener listener : this._subscriptions) {
                this.unsubscribe(listener);
            }
        }

        public List<ClientSessionChannel.MessageListener> getSubscribers() {
            return Collections.unmodifiableList(this._subscriptions);
        }

        public boolean release() {
            if (this._released) {
                return false;
            }
            if (this._subscriptions.isEmpty() && this._listeners.isEmpty()) {
                boolean removed;
                this._released = removed = AbstractClientSession.this._channels.remove(this.getId(), this);
                return removed;
            }
            return false;
        }

        public boolean isReleased() {
            return this._released;
        }

        protected void resetSubscriptions() {
            this.throwIfReleased();
            for (ClientSessionChannel.MessageListener l : this._subscriptions) {
                if (!this._subscriptions.remove(l)) continue;
                this._subscriptionCount.decrementAndGet();
            }
        }

        public String getId() {
            return this._id.toString();
        }

        public boolean isDeepWild() {
            return this._id.isDeepWild();
        }

        public boolean isMeta() {
            return this._id.isMeta();
        }

        public boolean isService() {
            return this._id.isService();
        }

        public boolean isBroadcast() {
            return !this.isMeta() && !this.isService();
        }

        public boolean isWild() {
            return this._id.isWild();
        }

        protected void notifyMessageListeners(Message message) {
            this.throwIfReleased();
            for (ClientSessionChannel.ClientSessionChannelListener clientSessionChannelListener : this._listeners) {
                if (!(clientSessionChannelListener instanceof ClientSessionChannel.MessageListener)) continue;
                this.notifyOnMessage((ClientSessionChannel.MessageListener)clientSessionChannelListener, message);
            }
            for (ClientSessionChannel.ClientSessionChannelListener clientSessionChannelListener : this._subscriptions) {
                if (!(clientSessionChannelListener instanceof ClientSessionChannel.MessageListener) || message.getData() == null) continue;
                this.notifyOnMessage((ClientSessionChannel.MessageListener)clientSessionChannelListener, message);
            }
        }

        protected void notifyOnMessage(ClientSessionChannel.MessageListener listener, Message message) {
            this.throwIfReleased();
            try {
                listener.onMessage((ClientSessionChannel)this, message);
            }
            catch (Exception x) {
                logger.info("Exception while invoking listener " + listener, (Throwable)x);
            }
        }

        public void setAttribute(String name, Object value) {
            this.throwIfReleased();
            this._attributes.setAttribute(name, value);
        }

        public Object getAttribute(String name) {
            this.throwIfReleased();
            return this._attributes.getAttribute(name);
        }

        public Set<String> getAttributeNames() {
            this.throwIfReleased();
            return this._attributes.keySet();
        }

        public Object removeAttribute(String name) {
            this.throwIfReleased();
            Object old = this.getAttribute(name);
            this._attributes.removeAttribute(name);
            return old;
        }

        protected void dump(StringBuilder b, String indent) {
            b.append(this.toString());
            b.append('\n');
            for (ClientSessionChannel.ClientSessionChannelListener clientSessionChannelListener : this._listeners) {
                b.append(indent);
                b.append(" +-");
                b.append(clientSessionChannelListener);
                b.append('\n');
            }
            for (ClientSessionChannel.MessageListener messageListener : this._subscriptions) {
                b.append(indent);
                b.append(" +-");
                b.append(messageListener);
                b.append('\n');
            }
        }

        protected void throwIfReleased() {
            if (this.isReleased()) {
                throw new IllegalStateException("Channel " + this + " has been released");
            }
        }

        public String toString() {
            return this._id.toString();
        }
    }
}

