/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cometd.client.transport.ClientTransport;

public class TransportRegistry {
    private final Map<String, ClientTransport> _transports = new HashMap<String, ClientTransport>();
    private final List<String> _allowed = new ArrayList<String>();

    public void add(ClientTransport transport) {
        if (transport != null) {
            this._transports.put(transport.getName(), transport);
            this._allowed.add(transport.getName());
        }
    }

    public Set<String> getKnownTransports() {
        return Collections.unmodifiableSet(this._transports.keySet());
    }

    public List<String> getAllowedTransports() {
        return Collections.unmodifiableList(this._allowed);
    }

    public List<ClientTransport> negotiate(Object[] requestedTransports, String bayeuxVersion) {
        ArrayList<ClientTransport> list = new ArrayList<ClientTransport>();
        for (String transport : this._allowed) {
            for (Object requestedTransport : requestedTransports) {
                if (!requestedTransport.equals(transport) || !this._transports.get(transport).accept(bayeuxVersion)) continue;
                list.add(this._transports.get(transport));
            }
        }
        return list;
    }

    public String[] findTransportTypes(String bayeuxVersion) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this._allowed) {
            ClientTransport transport = this._transports.get(name);
            if (!transport.accept(bayeuxVersion)) continue;
            result.add(transport.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public ClientTransport getTransport(String transport) {
        return this._transports.get(transport);
    }
}

