/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.rest.api.client.okhttp;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.codingmatters.rest.api.client.okhttp.HttpClientWrapper;
import org.codingmatters.rest.api.client.okhttp.exception.ConnectionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientWrapper
implements HttpClientWrapper {
    private static final Logger log = LoggerFactory.getLogger(OkHttpClientWrapper.class);
    public static final String OK_WRAPPER_CONNECT_TIMEOUT_ENV = "OK_WRAPPER_CONNECT_TIMEOUT";
    public static final String OK_WRAPPER_READ_TIMEOUT_ENV = "OK_WRAPPER_READ_TIMEOUT";
    public static final String OK_WRAPPER_WRITE_TIMEOUT_ENV = "OK_WRAPPER_WRITE_TIMEOUT";
    private final OkHttpClient delegate;

    public static HttpClientWrapper build() {
        return OkHttpClientWrapper.build(builder -> builder);
    }

    public static HttpClientWrapper build(Config config) {
        OkHttpClient.Builder builder = OkHttpClientWrapper.defaultConfiguration(new OkHttpClient.Builder());
        try {
            return new OkHttpClientWrapper(config.apply(builder).build());
        }
        catch (Exception e) {
            throw new RuntimeException("error building http client from config", e);
        }
    }

    private static OkHttpClient.Builder defaultConfiguration(OkHttpClient.Builder builder) {
        return builder.connectTimeout(OkHttpClientWrapper.envLong(OK_WRAPPER_CONNECT_TIMEOUT_ENV, "2000").longValue(), TimeUnit.MILLISECONDS).readTimeout(OkHttpClientWrapper.envLong(OK_WRAPPER_READ_TIMEOUT_ENV, "40000").longValue(), TimeUnit.MILLISECONDS).writeTimeout(OkHttpClientWrapper.envLong(OK_WRAPPER_WRITE_TIMEOUT_ENV, "40000").longValue(), TimeUnit.MILLISECONDS);
    }

    private static Long envLong(String name, String defaultValue) {
        return Long.parseLong(OkHttpClientWrapper.envString(name, defaultValue));
    }

    private static String envString(String name, String defaultValue) {
        if (System.getenv(name) != null) {
            return System.getenv(name);
        }
        return System.getProperty(name.replaceAll("_", ".").toLowerCase(), defaultValue);
    }

    private OkHttpClientWrapper(OkHttpClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public Response execute(Request request) throws IOException {
        try {
            return this.delegate.newCall(request).execute();
        }
        catch (SocketTimeoutException e) {
            if (e.getMessage().equals("connect timed out")) {
                throw new ConnectionTimeoutException("connection timed out", e);
            }
            throw e;
        }
        catch (NoRouteToHostException e) {
            throw new ConnectionTimeoutException("connection timed out", e);
        }
    }

    @FunctionalInterface
    public static interface Config {
        public OkHttpClient.Builder apply(OkHttpClient.Builder var1) throws Exception;

        public static Config truststoreFrompath(String path) {
            return builder -> {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
                SSLContext context = SSLContext.getInstance("TLS");
                KeyStore keyStore = KeyStore.getInstance("JKS");
                try (FileInputStream is = new FileInputStream(path);){
                    keyStore.load(is, null);
                }
                trustManagerFactory.init(keyStore);
                TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                context.init(null, trustManagers, null);
                return builder.sslSocketFactory(context.getSocketFactory(), (X509TrustManager)trustManagers[0]);
            };
        }
    }
}

