/*
 * Decompiled with CFR 0.152.
 */
package org.codenarc.rule;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.codenarc.analyzer.StringSourceAnalyzer;
import org.codenarc.analyzer.SuppressionAnalyzer;
import org.codenarc.rule.AbstractAstVisitorRule;
import org.codenarc.rule.InlineViolationsParser;
import org.codenarc.rule.Rule;
import org.codenarc.rule.Violation;
import org.codenarc.ruleset.ListRuleSet;
import org.codenarc.source.CustomCompilerPhaseSourceDecorator;
import org.codenarc.source.SourceCode;
import org.codenarc.source.SourceString;
import org.codenarc.test.AbstractTestCase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractRuleTestCase<T extends Rule>
extends AbstractTestCase {
    protected static final Object CONSTRUCTOR_METHOD_NAME;
    protected static final Object DEFAULT_TEST_FILES;
    protected static final Object DEFAULT_TEST_CLASS_NAMES;
    protected T rule;
    protected String sourceCodeName;
    protected String sourceCodePath;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AbstractRuleTestCase() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void testThatUnrelatedCodeHasNoViolations() {
        String SOURCE = "class MyClass { }";
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "keySet", 0, IndyInterface.bootstrap("invoke", "getProperties", 2, this)), "skipTestThatUnrelatedCodeHasNoViolations")) == false) {
            IndyInterface.bootstrap("invoke", "assertNoViolations", 2, this, SOURCE);
        }
    }

    @Test
    public void testThatInvalidCodeHasNoViolations() {
        String SOURCE = "@will not compile@ &^%$#";
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "keySet", 0, IndyInterface.bootstrap("invoke", "getProperties", 2, this)), "skipTestThatInvalidCodeHasNoViolations")) == false) {
            CallSite sourceCode = IndyInterface.bootstrap("invoke", "prepareSourceCode", 2, this, SOURCE);
            ValueRecorder valueRecorder = new ValueRecorder();
            try {
                T t = this.rule;
                valueRecorder.record(t, 8);
                valueRecorder.record(t, 8);
                CallSite callSite = sourceCode;
                valueRecorder.record((Object)callSite, 21);
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "applyTo", 0, t, callSite);
                valueRecorder.record((Object)callSite2, 13);
                CallSite callSite3 = IndyInterface.bootstrap("getProperty", "empty", 0, callSite2);
                valueRecorder.record((Object)callSite3, 33);
                if (IndyInterface.bootstrap("cast", "()", 0, callSite3) == false) {
                    throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert rule.applyTo(sourceCode).empty", (ValueRecorder)valueRecorder), null);
                }
                valueRecorder.clear();
            }
            catch (Throwable throwable) {
                valueRecorder.clear();
                throw throwable;
            }
        }
    }

    @Test
    public void testThatApplyToFilesMatchingValuesAreValidRegex() {
        IndyInterface.bootstrap("invoke", "assertValidRegex", 2, this, IndyInterface.bootstrap("getProperty", "applyToFilesMatching", 0, this.rule), "applyToFilesMatching");
        IndyInterface.bootstrap("invoke", "assertValidRegex", 2, this, IndyInterface.bootstrap("getProperty", "doNotApplyToFilesMatching", 0, this.rule), "doNotApplyToFilesMatching");
    }

    private void assertValidRegex(String regex, String name) {
        if (IndyInterface.bootstrap("cast", "()", 0, regex) != false) {
            try {
                IndyInterface.bootstrap("invoke", "compile", 0, Pattern.class, regex);
            }
            catch (PatternSyntaxException e) {
                IndyInterface.bootstrap("invoke", "fail", 2, this, new GStringImpl(new Object[]{name, regex, e}, new String[]{"The ", " value [", "] is not a valid regular expression: ", ""}));
            }
        }
    }

    protected abstract T createRule();

    protected void assertTwoViolations(String source, Integer lineNumber1, String sourceLineText1, Integer lineNumber2, String sourceLineText2) {
        CallSite violations = IndyInterface.bootstrap("invoke", "applyRuleTo", 2, this, source);
        public final class _assertTwoViolations_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _assertTwoViolations_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "lineNumber", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _assertTwoViolations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "sort", 0, violations, new _assertTwoViolations_closure1(this, this));
        if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, violations), (Object)2)) {
            throw InvokerHelper.createAssertError((Object)"(violations.size() == 2)", (Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, violations), IndyInterface.bootstrap("invoke", "join", 0, violations, "\n")}, new String[]{"Expected 2 violations\nFound ", ": \n", "\n"}));
        }
        IndyInterface.bootstrap("invoke", "assertViolation", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, violations, false), lineNumber1, sourceLineText1);
        IndyInterface.bootstrap("invoke", "assertViolation", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, violations, true), lineNumber2, sourceLineText2);
    }

    protected void assertInlineViolations(String annotatedSource) {
        CallSite parseResult = IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, InlineViolationsParser.class), annotatedSource);
        Map[] violationsMap = (Map[])IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "violations", 0, parseResult), Map[].class);
        IndyInterface.bootstrap("invoke", "assertViolations", 2, this, IndyInterface.bootstrap("getProperty", "source", 0, parseResult), violationsMap);
        if (IndyInterface.bootstrap("cast", "()", 0, violationsMap) == false) {
            StringBuilder stringBuilder = new StringBuilder("violationsMap. Values: ");
            stringBuilder.append((Object)"violationsMap = ");
            stringBuilder.append(InvokerHelper.toString((Object)violationsMap));
            throw InvokerHelper.createAssertError((Object)stringBuilder, (Object)"There must be at least one inline violation specified. If no violations are intended, then use assertNoViolations() instead");
        }
    }

    protected static String inlineViolation(String violationMessage) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "inlineViolation", 0, InlineViolationsParser.class, violationMessage));
    }

    protected static String removeInlineViolations(String annotatedSource) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "source", 0, IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, InlineViolationsParser.class), annotatedSource)));
    }

    protected void assertViolations(String source, Map ... violationMaps) {
        Reference rawViolations = new Reference((Object)IndyInterface.bootstrap("invoke", "applyRuleTo", 2, this, source));
        public final class _assertViolations_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _assertViolations_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object v) {
                return IndyInterface.bootstrap("getProperty", "lineNumber", 0, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _assertViolations_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "sort", 0, rawViolations.get(), new _assertViolations_closure2(this, this));
        if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, rawViolations.get()), (Object)IndyInterface.bootstrap("invoke", "size", 0, violationMaps))) {
            throw InvokerHelper.createAssertError((Object)"(rawViolations.size() == violationMaps.size())", (Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, violationMaps), IndyInterface.bootstrap("invoke", "size", 0, rawViolations.get()), IndyInterface.bootstrap("invoke", "join", 0, rawViolations.get(), "\n    ")}, new String[]{"Expected ", " violations\nFound ", ": \n    ", "\n"}));
        }
        Reference validKeys = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"line", "lineNumber", "source", "sourceLineText", "message", "messageText"}));
        public final class _assertViolations_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference validKeys;
            private /* synthetic */ Reference rawViolations;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _assertViolations_closure3(Object _outerInstance, Object _thisObject, Reference validKeys, Reference rawViolations) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.validKeys = reference2 = validKeys;
                this.rawViolations = reference = rawViolations;
            }

            public Object doCall(Object violationMap, Object index) {
                public final class _closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference validKeys;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure6(Object _outerInstance, Object _thisObject, Reference validKeys) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.validKeys = reference = validKeys;
                    }

                    public Object doCall(Object key) {
                        return ScriptBytecodeAdapter.isCase((Object)key, (Object)this.validKeys.get());
                    }

                    @Generated
                    public Object getValidKeys() {
                        return this.validKeys.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "every", 0, IndyInterface.bootstrap("invoke", "keySet", 0, violationMap), new _closure6((Object)this, this.getThisObject(), this.validKeys))) == false) {
                    throw InvokerHelper.createAssertError((Object)"violationMap.keySet().every({ java.lang.Object key -> ... })", (Object)new GStringImpl(new Object[]{this.validKeys.get()}, new String[]{"violationMap keys must be one of ", ""}));
                }
                CallSite callSite = IndyInterface.bootstrap("getProperty", "line", 0, violationMap);
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "source", 0, violationMap);
                CallSite callSite3 = IndyInterface.bootstrap("getProperty", "message", 0, violationMap);
                return IndyInterface.bootstrap("invoke", "assertViolation", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, this.rawViolations.get(), index), IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("getProperty", "lineNumber", 0, violationMap), IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : IndyInterface.bootstrap("getProperty", "sourceLineText", 0, violationMap), IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : IndyInterface.bootstrap("getProperty", "messageText", 0, violationMap));
            }

            @Generated
            public Object call(Object violationMap, Object index) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, violationMap, index);
            }

            @Generated
            public Object getValidKeys() {
                return this.validKeys.get();
            }

            @Generated
            public Object getRawViolations() {
                return this.rawViolations.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _assertViolations_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "eachWithIndex", 0, violationMaps, new _assertViolations_closure3(this, this, validKeys, rawViolations));
    }

    protected void assertTwoViolations(String source, Integer lineNumber1, String sourceLineText1, Object msg1, Integer lineNumber2, String sourceLineText2, Object msg2) {
        CallSite violations = IndyInterface.bootstrap("invoke", "applyRuleTo", 2, this, source);
        if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, violations), (Object)2)) {
            throw InvokerHelper.createAssertError((Object)"(violations.size() == 2)", (Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, violations), IndyInterface.bootstrap("invoke", "join", 0, violations, "\n")}, new String[]{"Expected 2 violations\nFound ", ": \n", "\n"}));
        }
        IndyInterface.bootstrap("invoke", "assertViolation", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, violations, false), lineNumber1, sourceLineText1, msg1);
        IndyInterface.bootstrap("invoke", "assertViolation", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, violations, true), lineNumber2, sourceLineText2, msg2);
    }

    protected void assertSingleViolation(String source, Integer lineNumber, String sourceLineText, Object messageText) {
        CallSite violations = IndyInterface.bootstrap("invoke", "applyRuleTo", 2, this, source);
        if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, violations), (Object)1)) {
            throw InvokerHelper.createAssertError((Object)"(violations.size() == 1)", (Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, violations), IndyInterface.bootstrap("invoke", "join", 0, violations, "\n"), sourceLineText}, new String[]{"Expected 1 violation\nFound ", ": \n", "\n  for sourceLineText: [", "]"}));
        }
        IndyInterface.bootstrap("invoke", "assertViolation", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, violations, false), lineNumber, sourceLineText, messageText);
    }

    protected void assertSingleViolation(String source, Closure closure) {
        CallSite violations = IndyInterface.bootstrap("invoke", "applyRuleTo", 2, this, source);
        if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, violations), (Object)1)) {
            throw InvokerHelper.createAssertError((Object)"(violations.size() == 1)", (Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, violations), IndyInterface.bootstrap("invoke", "join", 0, violations, "\n")}, new String[]{"Expected 1 violation\nFound ", ": \n", "\n"}));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "call", 0, closure, IndyInterface.bootstrap("invoke", "getAt", 0, violations, false))) == false) {
            throw InvokerHelper.createAssertError((Object)"closure.call(violations[0])", (Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, violations, false)}, new String[]{"Closure failed for ", ""}));
        }
    }

    protected void assertNoViolations(String source) {
        CallSite violations = IndyInterface.bootstrap("invoke", "applyRuleTo", 2, this, source);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "empty", 0, violations)) == false) {
            throw InvokerHelper.createAssertError((Object)"violations.empty", (Object)new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, violations), IndyInterface.bootstrap("invoke", "join", 0, violations, "\n")}, new String[]{"Expected no violations, but got ", ": \n", "\n"}));
        }
    }

    protected void assertViolation(Violation violation, Integer lineNumber, String sourceLineText, Object messageText) {
        Reference violation2 = new Reference((Object)violation);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Violation violation3 = (Violation)violation2.get();
            valueRecorder.record((Object)violation3, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "rule", 4, violation3);
            valueRecorder.record((Object)callSite, 18);
            T t = this.rule;
            valueRecorder.record(t, 26);
            valueRecorder.record(t, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, t);
            valueRecorder.record((Object)bl, 23);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert violation.rule == rule", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "lineNumber", 4, (Violation)violation2.get()), (Object)lineNumber)) {
            StringBuilder stringBuilder = new StringBuilder("(violation.lineNumber == lineNumber). Values: ");
            stringBuilder.append((Object)"lineNumber = ");
            stringBuilder.append(InvokerHelper.toString((Object)lineNumber));
            throw InvokerHelper.createAssertError((Object)stringBuilder, (Object)new GStringImpl(new Object[]{(Violation)violation2.get(), lineNumber, IndyInterface.bootstrap("getProperty", "lineNumber", 4, (Violation)violation2.get())}, new String[]{"Wrong line number for violation: \n", "\nExpected: ", "\nFound:    ", "\n"}));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, sourceLineText) != false) {
            ValueRecorder valueRecorder2 = new ValueRecorder();
            try {
                Violation violation4 = (Violation)violation2.get();
                valueRecorder2.record((Object)violation4, 8);
                CallSite callSite = IndyInterface.bootstrap("getProperty", "sourceLine", 4, violation4);
                valueRecorder2.record((Object)callSite, 18);
                if (IndyInterface.bootstrap("cast", "()", 0, callSite) == false) {
                    throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert violation.sourceLine", (ValueRecorder)valueRecorder2), null);
                }
                valueRecorder2.clear();
            }
            catch (Throwable throwable) {
                valueRecorder2.clear();
                throw throwable;
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "sourceLine", 4, (Violation)violation2.get()), sourceLineText)) == false) {
                throw InvokerHelper.createAssertError((Object)"violation.sourceLine.contains(sourceLineText)", (Object)new GStringImpl(new Object[]{sourceLineText, IndyInterface.bootstrap("getProperty", "sourceLine", 4, (Violation)violation2.get())}, new String[]{"Problem with source text:\nexpected to contain:  ", "\nactual:               ", "\n"}));
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, messageText) != false) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "message", 4, (Violation)violation2.get())) == false) {
                throw InvokerHelper.createAssertError((Object)"violation.message", (Object)"The violation message was null");
            }
            if (messageText instanceof Collection) {
                public final class _assertViolation_closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference violation;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _assertViolation_closure4(Object _outerInstance, Object _thisObject, Reference violation) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.violation = reference = violation;
                    }

                    public Object doCall(Object it) {
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "message", 4, IndyInterface.bootstrap("cast", "()", 0, this.violation.get())), IndyInterface.bootstrap("invoke", "toString", 0, it))) == false) {
                            throw InvokerHelper.createAssertError((Object)"violation.message.contains(it.toString())", (Object)new GStringImpl(new Object[]{it}, new String[]{"text does not contain [", "]"}));
                        }
                        return null;
                    }

                    @Generated
                    public Violation getViolation() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.violation.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _assertViolation_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, messageText, new _assertViolation_closure4(this, this, violation2));
            } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "message", 4, (Violation)violation2.get()), messageText)) == false) {
                throw InvokerHelper.createAssertError((Object)"violation.message.contains(messageText)", (Object)new GStringImpl(new Object[]{lineNumber, messageText, IndyInterface.bootstrap("getProperty", "message", 4, (Violation)violation2.get())}, new String[]{"Violation on line ", "\nExpected message text: [", "]\nFound message text:    [", "]\n"}));
            }
        }
    }

    protected List applyRuleTo(String source) {
        CallSite sourceCode = IndyInterface.bootstrap("invoke", "prepareSourceCode", 2, this, source);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = sourceCode;
            valueRecorder.record((Object)callSite, 8);
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "valid", 0, callSite);
            valueRecorder.record((Object)callSite2, 19);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite2) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert sourceCode.valid", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite violations = IndyInterface.bootstrap("invoke", "applyTo", 0, this.rule, sourceCode);
        IndyInterface.bootstrap("invoke", "removeSuppressedViolations", 2, this, sourceCode, violations);
        IndyInterface.bootstrap("invoke", "log", 2, this, new GStringImpl(new Object[]{violations}, new String[]{"violations=", ""}));
        return IndyInterface.bootstrap("cast", "()", 0, violations);
    }

    private void removeSuppressedViolations(SourceCode sourceCode, List<Violation> violations) {
        Reference suppressionAnalyzer = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, SuppressionAnalyzer.class, sourceCode));
        public final class _removeSuppressedViolations_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference suppressionAnalyzer;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeSuppressedViolations_closure5(Object _outerInstance, Object _thisObject, Reference suppressionAnalyzer) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.suppressionAnalyzer = reference = suppressionAnalyzer;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "isViolationSuppressed", 0, this.suppressionAnalyzer.get(), it);
            }

            @Generated
            public Object getSuppressionAnalyzer() {
                return this.suppressionAnalyzer.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeSuppressedViolations_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "removeAll", 0, violations, new _removeSuppressedViolations_closure5(this, this, suppressionAnalyzer));
    }

    private SourceCode prepareSourceCode(String source) {
        CallSite sourceCode = IndyInterface.bootstrap("init", "<init>", 0, SourceString.class, source, this.sourceCodePath, this.sourceCodeName);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "compilerPhase", 0, this.rule), (Object)IndyInterface.bootstrap("getProperty", "DEFAULT_COMPILER_PHASE", 0, SourceCode.class))) {
            sourceCode = IndyInterface.bootstrap("init", "<init>", 0, CustomCompilerPhaseSourceDecorator.class, sourceCode, IndyInterface.bootstrap("getProperty", "compilerPhase", 0, this.rule));
        }
        return IndyInterface.bootstrap("cast", "()", 0, sourceCode);
    }

    protected List manuallyApplyRule(String source) {
        CallSite analyzer = IndyInterface.bootstrap("init", "<init>", 0, StringSourceAnalyzer.class, source);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = analyzer;
            valueRecorder.record((Object)callSite, 8);
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "source", 0, callSite);
            valueRecorder.record((Object)callSite2, 17);
            CallSite callSite3 = IndyInterface.bootstrap("getProperty", "valid", 0, callSite2);
            valueRecorder.record((Object)callSite3, 24);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite3) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert analyzer.source.valid", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite results = IndyInterface.bootstrap("invoke", "analyze", 0, analyzer, IndyInterface.bootstrap("init", "<init>", 0, ListRuleSet.class, ScriptBytecodeAdapter.createList((Object[])new Object[]{this.rule})));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "violations", 0, results));
    }

    @BeforeEach
    public void setUpAbstractRuleTestCase() {
        CallSite callSite = IndyInterface.bootstrap("invoke", "createRule", 2, this);
        this.rule = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractRuleTestCase.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    protected void assertSingleViolation(String source, Integer lineNumber, String sourceLineText) {
        this.assertSingleViolation(source, lineNumber, sourceLineText, null);
    }

    @Generated
    protected void assertSingleViolation(String source, Integer lineNumber) {
        this.assertSingleViolation(source, lineNumber, null, null);
    }

    @Generated
    protected void assertSingleViolation(String source) {
        this.assertSingleViolation(source, null, null, null);
    }

    @Generated
    protected void assertViolation(Violation violation, Integer lineNumber, String sourceLineText) {
        Reference violation2 = new Reference((Object)violation);
        this.assertViolation((Violation)violation2.get(), lineNumber, sourceLineText, null);
    }

    static {
        String string = "<init>";
        CONSTRUCTOR_METHOD_NAME = string;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "DEFAULT_TEST_FILES", 0, AbstractAstVisitorRule.class);
        DEFAULT_TEST_FILES = callSite;
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "DEFAULT_TEST_CLASS_NAMES", 0, AbstractAstVisitorRule.class);
        DEFAULT_TEST_CLASS_NAMES = callSite2;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

