/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query.namedparameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codejargon.fluentjdbc.internal.query.SqlAndParams;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedParameterUtils;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSql;
import org.codejargon.fluentjdbc.internal.query.namedparameter.ParsedSql;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

public abstract class SqlAndParamsForNamed {
    public static SqlAndParams create(NamedTransformedSql namedTransformedSql, Map<String, Object> map) {
        Preconditions.checkArgument(namedTransformedSql.unnamedParameterCount() == 0, String.format("Querying with named parameters cannot be run with SQL statements containing positional parameters: %s", namedTransformedSql.sql()));
        return new SqlAndParams(namedTransformedSql.sql(), SqlAndParamsForNamed.params(namedTransformedSql.parsedSql(), map));
    }

    public static List<Object> params(ParsedSql parsedSql, Map<String, ?> map) {
        return SqlAndParamsForNamed.flatten(NamedParameterUtils.buildValueArray(parsedSql, map));
    }

    private static List<Object> flatten(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (object instanceof Collection) {
                arrayList.addAll((Collection)object);
                continue;
            }
            arrayList.add(object);
        }
        return Collections.unmodifiableList(arrayList);
    }
}

