/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.api.FluentJdbcSqlException;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.api.query.BatchQuery;
import org.codejargon.fluentjdbc.api.query.Query;
import org.codejargon.fluentjdbc.api.query.SelectQuery;
import org.codejargon.fluentjdbc.api.query.Transaction;
import org.codejargon.fluentjdbc.api.query.UpdateQuery;
import org.codejargon.fluentjdbc.api.query.inspection.DatabaseInspection;
import org.codejargon.fluentjdbc.internal.integration.QueryConnectionReceiverInternal;
import org.codejargon.fluentjdbc.internal.query.BatchQueryInternal;
import org.codejargon.fluentjdbc.internal.query.DatabaseInspectionInternal;
import org.codejargon.fluentjdbc.internal.query.PreparedStatementFactory;
import org.codejargon.fluentjdbc.internal.query.QueryConfig;
import org.codejargon.fluentjdbc.internal.query.QueryRunnerConnection;
import org.codejargon.fluentjdbc.internal.query.SelectQueryInternal;
import org.codejargon.fluentjdbc.internal.query.TransactionInternal;
import org.codejargon.fluentjdbc.internal.query.UpdateQueryInternal;

public class QueryInternal
implements Query {
    final ConnectionProvider connectionProvider;
    final QueryConfig config;
    final PreparedStatementFactory preparedStatementFactory;

    public QueryInternal(ConnectionProvider connectionProvider, QueryConfig queryConfig) {
        this.connectionProvider = connectionProvider;
        this.config = queryConfig;
        this.preparedStatementFactory = new PreparedStatementFactory(queryConfig);
    }

    @Override
    public SelectQuery select(String string) {
        return new SelectQueryInternal(string, this);
    }

    @Override
    public UpdateQuery update(String string) {
        return new UpdateQueryInternal(string, this);
    }

    @Override
    public BatchQuery batch(String string) {
        return new BatchQueryInternal(string, this);
    }

    @Override
    public Transaction transaction() {
        return new TransactionInternal(this);
    }

    @Override
    public DatabaseInspection databaseInspection() {
        return new DatabaseInspectionInternal(this);
    }

    <T> T query(QueryRunnerConnection<T> queryRunnerConnection, String string) {
        try {
            QueryConnectionReceiverInternal<T> queryConnectionReceiverInternal = new QueryConnectionReceiverInternal<T>(queryRunnerConnection);
            Optional<Connection> optional = TransactionInternal.transactionedConnection(this.connectionProvider);
            if (!optional.isPresent()) {
                this.connectionProvider.provide(queryConnectionReceiverInternal);
            } else {
                queryConnectionReceiverInternal.receive(optional.get());
            }
            return queryConnectionReceiverInternal.returnValue();
        }
        catch (SQLException sQLException) {
            throw this.queryException(string, Optional.empty(), Optional.of(sQLException));
        }
    }

    FluentJdbcException queryException(String string, Optional<String> optional, Optional<SQLException> optional2) {
        String string2 = String.format("Error running query" + (optional.isPresent() ? ": " + optional.get() : "") + ", %s", string);
        return optional2.isPresent() ? new FluentJdbcSqlException(string2, optional2.get()) : new FluentJdbcException(string2);
    }

    void assignParams(PreparedStatement preparedStatement, List<?> list) throws SQLException {
        this.preparedStatementFactory.assignParams(preparedStatement, list);
    }
}

