/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.support;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.codejargon.fluentjdbc.internal.support.Iterables;

public class FindFirst<T> {
    private static final Predicate notNull = object -> object != null;
    private Optional<Iterable<T>> elements;
    private Optional<Iterable<Supplier<T>>> elementsLazy;

    public FindFirst(Optional<Iterable<T>> optional, Optional<Iterable<Supplier<T>>> optional2) {
        this.elements = optional;
        this.elementsLazy = optional2;
    }

    @SafeVarargs
    public static <T> FindFirst<T> from(T ... TArray) {
        return FindFirst.from(Arrays.asList(TArray));
    }

    public static <T> FindFirst<T> from(Iterable<T> iterable) {
        return new FindFirst<T>(Optional.of(iterable), Optional.empty());
    }

    @SafeVarargs
    public static <T> FindFirst<T> fromLazy(Supplier<T> ... supplierArray) {
        return FindFirst.fromLazy(Arrays.asList(supplierArray));
    }

    public static <T> FindFirst<T> fromLazy(Iterable<Supplier<T>> iterable) {
        return new FindFirst<T>(Optional.empty(), Optional.of(iterable));
    }

    public Optional<T> which(Predicate<T> predicate) {
        return this.stream().filter(predicate).findFirst();
    }

    public Optional<T> whichIsNotNull() {
        return this.which(notNull);
    }

    private Stream<T> stream() {
        return this.elements.isPresent() ? Iterables.stream(this.elements.get()) : Iterables.stream(this.elementsLazy.get()).map(Supplier::get);
    }
}

