/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codejargon.fluentjdbc.api.FluentJdbcSqlException;
import org.codejargon.fluentjdbc.api.ParamSetter;
import org.codejargon.fluentjdbc.internal.support.Sets;

public class ParamAssigner {
    private final Map<Class, ParamSetter> paramSetters;
    private Set<String> paramTypeLookupFailsOnDriver = Sets.immutableOf();
    private static final Set<String> nullWithObject = Sets.immutableOf(new String[]{"Microsoft SQL Server", "Informix"});
    private static final Set<String> nullWithVarchar = Sets.immutableOf(new String[]{"DB2", "jConnect", "SQLServer", "Apache Derby"});

    public ParamAssigner(Map<Class, ParamSetter> paramSetters) {
        this.paramSetters = paramSetters;
    }

    void assignParams(PreparedStatement statement, List<Object> params) {
        int i = 1;
        for (Object param : params) {
            this.assignParam(statement, i, param);
            ++i;
        }
    }

    private void assignParam(PreparedStatement statement, Integer index, Object param) {
        try {
            if (param == null) {
                this.assignNull(statement, index);
            } else {
                this.assignNonNull(param, statement, index);
            }
        }
        catch (SQLException e) {
            throw new FluentJdbcSqlException(String.format("Error mapping index %s, object %s", index, param != null ? param.getClass().getName() : "null"), e);
        }
    }

    private void assignNull(PreparedStatement statement, Integer index) throws SQLException {
        if (!this.paramTypeLookupFailsOnDriver.contains(this.driverName(statement))) {
            this.assignNullWithSqlType(statement, index);
        } else {
            this.assignNullWithoutSqlType(statement, index);
        }
    }

    private void assignNonNull(Object param, PreparedStatement statement, Integer index) throws SQLException {
        if (this.paramSetters.containsKey(param.getClass())) {
            this.paramSetters.get(param.getClass()).set(param, statement, index);
        } else {
            statement.setObject(index, param);
        }
    }

    private void assignNullWithSqlType(PreparedStatement statement, Integer index) throws SQLException {
        try {
            Integer sqlType = statement.getParameterMetaData().getParameterType(index);
            statement.setNull(index, sqlType);
        }
        catch (SQLException e) {
            this.paramTypeLookupFailsOnDriver = Sets.merge(this.paramTypeLookupFailsOnDriver, Sets.immutableOf(new String[]{this.driverName(statement)}));
            this.assignNullWithoutSqlType(statement, index);
        }
    }

    private void assignNullWithoutSqlType(PreparedStatement statement, Integer index) throws FluentJdbcSqlException {
        try {
            String driverName = this.driverName(statement);
            if (this.hasPrefix(nullWithObject, driverName)) {
                statement.setObject(index, null);
            } else if (this.hasPrefix(nullWithVarchar, driverName)) {
                statement.setNull(index, 12);
            } else {
                statement.setNull(index, 0);
            }
        }
        catch (SQLException ex) {
            throw new FluentJdbcSqlException(String.format("Failed to assign null value at index %s", index), ex);
        }
    }

    private String driverName(PreparedStatement statement) throws SQLException {
        return statement.getConnection().getMetaData().getDriverName();
    }

    private boolean hasPrefix(Set<String> driverPrefixes, String driver) {
        for (String string : driverPrefixes) {
            if (!driver.startsWith(string)) continue;
            return true;
        }
        return false;
    }
}

