/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.codejargon.fluentjdbc.internal.query.QueryConfig;
import org.codejargon.fluentjdbc.internal.query.SingleQueryBase;
import org.codejargon.fluentjdbc.internal.query.SqlAndParams;

class PreparedStatementFactory {
    private final QueryConfig config;

    PreparedStatementFactory(QueryConfig config) {
        this.config = config;
    }

    PreparedStatement createSingle(Connection con, SingleQueryBase singleQueryBase, boolean fetchGenerated) throws SQLException {
        SqlAndParams sqlAndParams = singleQueryBase.sqlAndParams(this.config);
        PreparedStatement statement = this.prepareStatement(con, sqlAndParams.sql(), fetchGenerated);
        singleQueryBase.customizeQuery(statement, this.config);
        this.assignParams(statement, sqlAndParams.params());
        return statement;
    }

    PreparedStatement createBatch(Connection con, String sql) throws SQLException {
        return this.prepareStatement(con, sql, false);
    }

    void assignParams(PreparedStatement statement, List<?> params) throws SQLException {
        this.config.paramAssigner.assignParams(statement, params);
    }

    private PreparedStatement prepareStatement(Connection con, String sql, Boolean fetchGenerated) throws SQLException {
        return fetchGenerated != false ? con.prepareStatement(sql, 1) : con.prepareStatement(sql);
    }
}

